/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.json;

import java.lang.reflect.Array;
import java.text.StringCharacterIterator;
import java.time.temporal.Temporal;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;

public class JsonWriter {
    private final StringBuilder s = new StringBuilder(512);
    private final Stack<Object> calls = new Stack();
    private static final String spaces = "                                                            ";
    private static final int stepsize = 3;
    private static final int max = "                                                            ".length() / 3;
    private int level = 0;
    private static final char[] hex = "0123456789ABCDEF".toCharArray();

    public String write(Map<String, Object> values) {
        this.s.setLength(0);
        this.value(values);
        return this.s.toString();
    }

    private void indent() {
        if (0 == this.level) {
            return;
        }
        if (this.level < max) {
            this.add(spaces.substring(0, this.level * 3));
        } else {
            this.add(spaces);
            for (int i = this.level - max; i < this.level; ++i) {
                for (int j = 0; j < 3; ++j) {
                    this.add(" ");
                }
            }
        }
    }

    private void nl() {
        this.add("\n");
        this.indent();
    }

    private void stepIn(char c) {
        this.add(c);
        ++this.level;
        this.nl();
    }

    private void stepOut(char c) {
        --this.level;
        this.nl();
        this.add(c);
    }

    private void emptyArray() {
        this.add("[]");
    }

    private void value(Object object) {
        if (object == null || this.cyclic(object)) {
            this.add("null");
        } else {
            this.calls.push(object);
            if (object instanceof Boolean) {
                this.bool((Boolean)object);
            } else if (object instanceof Number || object instanceof Temporal) {
                this.add(object);
            } else if (object instanceof String || object instanceof Character) {
                this.string(object);
            } else if (object instanceof Map) {
                this.map((Map)object);
            } else if (object.getClass().isArray()) {
                this.array(object);
            } else if (object instanceof Iterator) {
                this.array((Iterator)object);
            } else if (object instanceof Collection) {
                this.array(((Collection)object).iterator());
            } else {
                System.err.println(this.s.toString());
                throw new IllegalArgumentException("cannot be serialized in json: " + object);
            }
            this.calls.pop();
        }
    }

    private boolean cyclic(Object object) {
        for (Object e : this.calls) {
            if (object != e) continue;
            return true;
        }
        return false;
    }

    private void map(Map<String, Object> map) {
        this.stepIn('{');
        Iterator<Map.Entry<String, Object>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> e = it.next();
            this.value(e.getKey());
            this.add(": ");
            this.value(e.getValue());
            if (!it.hasNext()) continue;
            this.add(',');
            this.nl();
        }
        this.stepOut('}');
    }

    private void array(Iterator<?> it) {
        if (it.hasNext()) {
            this.stepIn('[');
            while (it.hasNext()) {
                this.value(it.next());
                if (!it.hasNext()) continue;
                this.add(",");
                this.nl();
            }
            this.stepOut(']');
        } else {
            this.emptyArray();
        }
    }

    private void array(Object object) {
        int length = Array.getLength(object);
        if (length > 0) {
            this.stepIn('[');
            for (int i = 0; i < length; ++i) {
                this.value(Array.get(object, i));
                if (i >= length - 1) continue;
                this.add(',');
                this.nl();
            }
            this.stepOut(']');
        } else {
            this.emptyArray();
        }
    }

    private void bool(boolean b) {
        this.add(Boolean.valueOf(b).toString());
    }

    private void string(Object obj) {
        this.add('\"');
        StringCharacterIterator it = new StringCharacterIterator(obj.toString());
        char c = it.first();
        while (c != '\uffff') {
            if (c == '\"') {
                this.add("\\\"");
            } else if (c == '\\') {
                this.add("\\\\");
            } else if (c == '/') {
                this.add("\\/");
            } else if (c == '\b') {
                this.add("\\b");
            } else if (c == '\f') {
                this.add("\\f");
            } else if (c == '\n') {
                this.add("\\n");
            } else if (c == '\r') {
                this.add("\\r");
            } else if (c == '\t') {
                this.add("\\t");
            } else if (Character.isISOControl(c)) {
                this.unicode(c);
            } else {
                this.add(c);
            }
            c = it.next();
        }
        this.add('\"');
    }

    private void add(Object obj) {
        this.s.append(obj);
    }

    private void add(char c) {
        this.s.append(c);
    }

    private void unicode(char c) {
        this.add("\\u");
        int n = c;
        for (int i = 0; i < 4; ++i) {
            int digit = (n & 0xF000) >> 12;
            this.add(hex[digit]);
            n <<= 4;
        }
    }
}

