/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.json;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.minimalj.application.Configuration;
import org.minimalj.frontend.impl.json.JsonInput;
import org.minimalj.frontend.impl.json.JsonOutput;
import org.minimalj.frontend.impl.json.JsonPageManager;
import org.minimalj.frontend.impl.json.JsonReader;

public class JsonSessionManager {
    private static final Logger logger = Logger.getLogger(JsonSessionManager.class.getName());
    private static final int MAX_SESSIONS = Integer.valueOf(Configuration.get("MjMaxSessions", "30"));
    private final Map<String, JsonPageManager> sessions = new HashMap<String, JsonPageManager>();
    private final List<String> sessionList = new ArrayList<String>();

    private JsonPageManager getSession(String sessionId) {
        this.sessionList.remove(sessionId);
        this.sessionList.add(sessionId);
        return this.sessions.get(sessionId);
    }

    private String createSession() {
        String sessionId;
        if (this.sessionList.size() >= MAX_SESSIONS) {
            sessionId = this.sessionList.get(0);
            this.sessions.remove(sessionId);
            this.sessionList.remove(sessionId);
        }
        sessionId = UUID.randomUUID().toString();
        JsonPageManager session = new JsonPageManager();
        this.sessions.put(sessionId, session);
        return sessionId;
    }

    public String handle(String json) {
        JsonOutput output;
        HashMap<String, String> data = (HashMap<String, String>)new JsonReader().read(json);
        boolean validSession = true;
        String sessionId = (String)data.get("session");
        if (!this.sessions.containsKey(sessionId)) {
            validSession = data.containsKey("showDefaultPage");
            sessionId = this.createSession();
            if (!validSession) {
                data = new HashMap<String, String>();
                data.put("showDefaultPage", "");
            }
        }
        JsonPageManager session = this.getSession(sessionId);
        try {
            JsonInput input = new JsonInput((Map<String, Object>)data);
            output = session.handle(input);
        }
        catch (Exception x) {
            output = new JsonOutput();
            output.add("error", x.getClass().getSimpleName() + ":\n" + x.getMessage());
            logger.log(Level.SEVERE, "Internal Error", x);
            x.printStackTrace();
        }
        if (!validSession) {
            output.add("error", "Invalid session. Please close and reopen tab.");
        }
        output.add("session", sessionId);
        return output.toString();
    }
}

