/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.json;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.minimalj.application.Application;
import org.minimalj.frontend.Frontend;
import org.minimalj.frontend.action.Action;
import org.minimalj.frontend.action.ActionGroup;
import org.minimalj.frontend.impl.json.JsonAction;
import org.minimalj.frontend.impl.json.JsonComponent;
import org.minimalj.frontend.impl.json.JsonDialog;
import org.minimalj.frontend.impl.json.JsonFrontend;
import org.minimalj.frontend.impl.json.JsonInput;
import org.minimalj.frontend.impl.json.JsonInputComponent;
import org.minimalj.frontend.impl.json.JsonLookup;
import org.minimalj.frontend.impl.json.JsonOutput;
import org.minimalj.frontend.impl.json.JsonTable;
import org.minimalj.frontend.impl.json.JsonTextField;
import org.minimalj.frontend.impl.util.PageList;
import org.minimalj.frontend.impl.util.PageStore;
import org.minimalj.frontend.page.IDialog;
import org.minimalj.frontend.page.Page;
import org.minimalj.frontend.page.PageManager;
import org.minimalj.security.Authentication;
import org.minimalj.security.AuthenticationFailedPage;
import org.minimalj.security.Subject;
import org.minimalj.security.UserPasswordAuthentication;
import org.minimalj.util.LocaleContext;

public class JsonPageManager
implements PageManager,
Authentication.LoginListener {
    private Subject subject;
    private final Map<String, JsonComponent> componentById = new HashMap<String, JsonComponent>(100);
    private List<Object> navigation;
    private final PageList visiblePageAndDetailsList = new PageList();
    private JsonOutput output;
    private final JsonComponent.JsonPropertyListener propertyListener = new JsonSessionPropertyChangeListener();
    private final PageStore pageStore = new PageStore();

    @Override
    public void loginSucceded(Subject subject) {
        this.subject = subject;
        Subject.setCurrent(subject);
        this.componentById.clear();
        this.navigation = this.createNavigation();
        this.register(this.navigation);
        this.output.add("navigation", this.navigation);
    }

    @Override
    public void loginCancelled() {
        if (this.subject == null && Application.getInstance().isLoginRequired()) {
            this.show(new AuthenticationFailedPage());
        }
    }

    public String handle(String inputString) {
        JsonInput input = new JsonInput(inputString);
        JsonOutput output = this.handle(input);
        return output.toString();
    }

    public JsonOutput handle(JsonInput input) {
        List pageIds;
        String login;
        String removeReference;
        String openLookupDialog;
        String loadSuggestions;
        String search;
        String tableExtendContent;
        Map<String, Object> tableSelection;
        Map<String, Object> tableSortAction;
        Map<String, Object> tableAction;
        JsonFrontend.setSession(this);
        Subject.setCurrent(this.subject);
        String locale = (String)input.getObject("locale");
        if (locale != null) {
            LocaleContext.setCurrent(Locale.forLanguageTag(locale));
        }
        JsonFrontend.setUseInputTypes(Boolean.TRUE.equals(input.getObject("inputTypes")));
        this.output = new JsonOutput();
        if (input.containsObject("showDefaultPage")) {
            Page page = Application.getInstance().createDefaultPage();
            this.show(page, null);
            this.navigation = this.createNavigation();
            this.register(this.navigation);
            this.output.add("navigation", this.navigation);
            this.output.add("applicationName", Application.getInstance().getName());
        }
        if (input.containsObject("closePage")) {
            String pageId = (String)input.getObject("closePage");
            this.visiblePageAndDetailsList.removeAllFrom(pageId);
        }
        Map<String, Object> changedValues = input.get("changedValue");
        for (Map.Entry<String, Object> entry : changedValues.entrySet()) {
            String componentId = entry.getKey();
            Object newValue = entry.getValue();
            JsonComponent component = this.componentById.get(componentId);
            ((JsonInputComponent)component).changedValue(newValue);
        }
        String actionId = (String)input.getObject("activatedAction");
        if (actionId != null) {
            JsonAction action = (JsonAction)this.componentById.get(actionId);
            action.action();
        }
        if ((tableAction = input.get("tableAction")) != null && !tableAction.isEmpty()) {
            JsonTable table = (JsonTable)this.componentById.get(tableAction.get("table"));
            int row = ((Long)tableAction.get("row")).intValue();
            table.action(row);
        }
        if ((tableSortAction = input.get("tableSortAction")) != null && !tableSortAction.isEmpty()) {
            JsonTable table = (JsonTable)this.componentById.get(tableSortAction.get("table"));
            int column = ((Long)tableSortAction.get("column")).intValue();
            table.sort(column);
        }
        if ((tableSelection = input.get("tableSelection")) != null && !tableSelection.isEmpty()) {
            JsonTable table = (JsonTable)this.componentById.get(tableSelection.get("table"));
            List rows = (List)tableSelection.get("rows");
            table.selection(rows);
        }
        if ((tableExtendContent = (String)input.getObject("tableExtendContent")) != null) {
            JsonTable table = (JsonTable)this.componentById.get(tableExtendContent);
            this.output.add("tableId", tableExtendContent);
            this.output.add("tableExtendContent", table.extendContent());
            this.output.add("extendable", table.isExtendable());
        }
        if ((search = (String)input.getObject("search")) != null) {
            Page searchPage = Application.getInstance().createSearchPage(search);
            this.show(searchPage);
        }
        if ((loadSuggestions = (String)input.getObject("loadSuggestions")) != null) {
            JsonTextField textField = (JsonTextField)this.componentById.get(loadSuggestions);
            String searchText = (String)input.getObject("searchText");
            List<String> suggestions = textField.getSuggestions().search(searchText);
            this.output.add("suggestions", suggestions);
            this.output.add("loadSuggestions", loadSuggestions);
        }
        if ((openLookupDialog = (String)input.getObject("openLookupDialog")) != null) {
            JsonLookup lookup = (JsonLookup)this.componentById.get(openLookupDialog);
            lookup.showLookupDialog();
        }
        if ((removeReference = (String)input.getObject("removeReference")) != null) {
            JsonLookup lookup = (JsonLookup)this.componentById.get(removeReference);
            lookup.setValue(null);
        }
        if ((login = (String)input.getObject("login")) != null || this.subject == null && Frontend.loginAtStart() && !Boolean.TRUE.equals(input.getObject("dialogVisible"))) {
            new UserPasswordAuthentication.UserPasswordAction(this).action();
        }
        if ((pageIds = (List)input.getObject("showPages")) != null) {
            this.show(pageIds);
        }
        Subject.setCurrent(null);
        JsonFrontend.setSession(null);
        return this.output;
    }

    @Override
    public void show(Page page) {
        this.show(page, null);
    }

    @Override
    public void showDetail(Page mainPage, Page detail) {
        int pageIndex = this.visiblePageAndDetailsList.indexOf(detail);
        if (pageIndex < 0) {
            String mainPageId = this.visiblePageAndDetailsList.getId(mainPage);
            this.show(detail, mainPageId);
        } else {
            String pageId = this.visiblePageAndDetailsList.getId(pageIndex);
            this.output.add("pageId", pageId);
            this.output.add("title", detail.getTitle());
        }
    }

    private void show(Page page, String masterPageId) {
        if (masterPageId == null) {
            this.visiblePageAndDetailsList.clear();
            this.componentById.clear();
            this.register(this.navigation);
        } else {
            this.visiblePageAndDetailsList.removeAllAfter(masterPageId);
        }
        String pageId = this.pageStore.put(page);
        this.output.add("showPage", this.createJson(page, pageId, masterPageId));
        this.visiblePageAndDetailsList.put(pageId, page);
    }

    private void show(List<String> pageIds) {
        ArrayList<JsonComponent> jsonList = new ArrayList<JsonComponent>();
        this.visiblePageAndDetailsList.clear();
        String previousId = null;
        for (String pageId : pageIds) {
            Page page = this.pageStore.get(pageId);
            this.visiblePageAndDetailsList.put(pageId, page);
            jsonList.add(this.createJson(page, pageId, previousId));
            previousId = pageId;
        }
        this.output.add("showPages", jsonList);
    }

    private JsonComponent createJson(Page page, String pageId, String masterPageId) {
        JsonComponent json = new JsonComponent("page");
        json.put("masterPageId", (Object)masterPageId);
        json.put("pageId", (Object)pageId);
        json.put("title", (Object)page.getTitle());
        JsonComponent content = (JsonComponent)((Object)page.getContent());
        this.register(content);
        json.put("content", (Object)content);
        List<Object> actionMenu = this.createActionMenu(page);
        this.register(actionMenu);
        json.put("actionMenu", (Object)actionMenu);
        return json;
    }

    @Override
    public void hideDetail(Page page) {
        this.output.add("hidePage", this.visiblePageAndDetailsList.getId(page));
        this.visiblePageAndDetailsList.removeAllFrom(page);
    }

    @Override
    public boolean isDetailShown(Page page) {
        return this.visiblePageAndDetailsList.contains(page);
    }

    @Override
    public IDialog showDialog(String title, Frontend.IContent content, Action saveAction, Action closeAction, Action ... actions) {
        return new JsonDialog(title, content, saveAction, actions);
    }

    @Override
    public <T> IDialog showSearchDialog(Frontend.Search<T> index, Object[] keys, Frontend.TableActionListener<T> listener) {
        return new JsonDialog.JsonSearchDialog<T>(index, keys, listener);
    }

    @Override
    public void showMessage(String text) {
        this.output.add("message", text);
    }

    @Override
    public void showError(String text) {
        this.output.add("error", text);
    }

    private List<Object> createNavigation() {
        List<Action> navigationActions = Application.getInstance().getNavigation();
        List<Object> navigationItems = this.createActions(navigationActions);
        return navigationItems;
    }

    private List<Object> createActionMenu(Page page) {
        List<Action> actions = page.getActions();
        if (actions != null && actions.size() > 0) {
            return this.createActions(actions);
        }
        return null;
    }

    List<Object> createActions(List<Action> actions) {
        ArrayList<Object> items = new ArrayList<Object>();
        for (Action action : actions) {
            items.add(this.createAction(action));
        }
        return items;
    }

    List<Object> createActions(Action[] actions) {
        return this.createActions(Arrays.asList(actions));
    }

    JsonComponent createAction(Action action) {
        JsonComponent item;
        if (action instanceof ActionGroup) {
            ActionGroup actionGroup = (ActionGroup)action;
            item = new JsonAction.JsonActionGroup();
            item.put("items", (Object)this.createActions(actionGroup.getItems()));
        } else {
            item = new JsonAction(action);
        }
        item.put("name", (Object)action.getName());
        return item;
    }

    public void register(Object o) {
        if (o instanceof JsonComponent) {
            JsonComponent component = (JsonComponent)o;
            String id = component.getId();
            if (id != null) {
                this.componentById.put(component.getId(), component);
            }
            component.setPropertyListener(this.propertyListener);
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            for (Object o2 : map.values()) {
                this.register(o2);
            }
        }
        if (o instanceof List) {
            List list = (List)o;
            for (Object o2 : list) {
                this.register(o2);
            }
        }
    }

    public void openDialog(JsonDialog jsonDialog) {
        this.register(jsonDialog);
        this.output.add("dialog", jsonDialog);
    }

    public void closeDialog(String id) {
        this.output.add("closeDialog", id);
    }

    public void clearContent(String elementId) {
        this.output.removeContent(elementId);
    }

    public void addContent(String elementId, JsonComponent content) {
        this.register(content);
        this.output.addContent(elementId, content);
    }

    private class JsonSessionPropertyChangeListener
    implements JsonComponent.JsonPropertyListener {
        private JsonSessionPropertyChangeListener() {
        }

        @Override
        public void propertyChange(String componentId, String property, Object value) {
            JsonPageManager.this.output.propertyChange(componentId, property, value);
        }
    }
}

