/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.json;

import java.util.Objects;
import org.minimalj.frontend.Frontend;
import org.minimalj.frontend.impl.json.JsonComponent;

public abstract class JsonInputComponent<T>
extends JsonComponent
implements Frontend.Input<T> {
    public static final String VALUE = "value";
    public static final String EDITABLE = "editable";
    private final Frontend.InputComponentListener changeListener;

    public JsonInputComponent(String type, Frontend.InputComponentListener changeListener) {
        super(type);
        this.changeListener = changeListener;
    }

    @Override
    public void setEditable(boolean editable) {
        this.put(EDITABLE, (Object)editable);
    }

    void changedValue(Object value) {
        Object oldValue = super.putSilent(VALUE, value);
        if (!Objects.equals(oldValue, value)) {
            this.fireChange();
        }
    }

    void fireChange() {
        this.changeListener.changed(this);
    }
}

