/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.json;

import org.minimalj.frontend.Frontend;
import org.minimalj.frontend.impl.json.JsonComponent;
import org.minimalj.util.StringUtils;

public class JsonHtmlContent
extends JsonComponent
implements Frontend.IContent {
    public JsonHtmlContent(String htmlOrUrl) {
        super(JsonHtmlContent.isUrl(htmlOrUrl) ? "Url" : "Html", false);
        this.put("htmlOrUrl", (Object)this.convert(htmlOrUrl));
    }

    private static boolean isUrl(String htmlOrUrl) {
        return !htmlOrUrl.startsWith("<") && (StringUtils.isUrl(htmlOrUrl) || htmlOrUrl.endsWith(".html"));
    }

    private String convert(String htmlOrUrl) {
        if (this.get("type").equals("Url") || htmlOrUrl.startsWith("<")) {
            return htmlOrUrl;
        }
        return "<html>" + StringUtils.escapeHTML(htmlOrUrl) + "</html>";
    }
}

