/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.json;

import java.util.ArrayList;
import java.util.List;
import org.minimalj.frontend.Frontend;
import org.minimalj.frontend.impl.json.JsonComponent;

public class JsonFormContent
extends JsonComponent
implements Frontend.FormContent {
    public static final String CAPTION = "caption";
    public static final String VALIDATION_MESSAGE = "validationMessage";
    public static final String SPAN = "span";
    private final List<List<JsonComponent>> rows = new ArrayList<List<JsonComponent>>();
    private final int columns;
    private List<JsonComponent> actualRow = new ArrayList<JsonComponent>();
    private int actualColumn;

    public JsonFormContent(int columns, int columnWidth) {
        super("Form");
        if (columns < 1) {
            throw new IllegalArgumentException(JsonFormContent.class.getSimpleName() + " can only work with at least 1 column");
        }
        this.columns = columns;
        this.put("columns", (Object)columns);
        this.put("columnWidth", (Object)columnWidth);
        this.put("rows", (Object)this.rows);
        this.createNewRow();
    }

    private void createNewRow() {
        this.actualRow = new ArrayList<JsonComponent>();
        this.rows.add(this.actualRow);
        this.actualColumn = 0;
    }

    @Override
    public void add(Frontend.IComponent component) {
        JsonComponent jsonComponent = (JsonComponent)component;
        if (this.actualColumn > 0) {
            this.createNewRow();
        }
        if (this.columns > 1) {
            jsonComponent.put(SPAN, (Object)this.columns);
        }
        this.actualRow.add(jsonComponent);
        this.actualColumn = this.columns;
    }

    @Override
    public void add(String caption, Frontend.IComponent component, int span) {
        JsonComponent jsonComponent = (JsonComponent)component;
        jsonComponent.put(CAPTION, (Object)caption);
        if (this.actualColumn >= this.columns) {
            this.createNewRow();
        }
        if (span > 1) {
            jsonComponent.put(SPAN, (Object)span);
        }
        this.actualRow.add(jsonComponent);
        this.actualColumn += span;
    }

    @Override
    public void setValidationMessages(Frontend.IComponent component, List<String> validationMessages) {
        JsonComponent jsonComponent = (JsonComponent)component;
        if (validationMessages.size() == 1) {
            jsonComponent.put(VALIDATION_MESSAGE, (Object)validationMessages.get(0));
        } else if (!validationMessages.isEmpty()) {
            StringBuilder s = new StringBuilder();
            for (int i = 0; i < validationMessages.size() - 1; ++i) {
                s.append(validationMessages.get(i));
                s.append("<BR>");
            }
            s.append(validationMessages.get(validationMessages.size() - 1));
        } else {
            jsonComponent.put(VALIDATION_MESSAGE, (Object)"");
        }
    }
}

