/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.json;

import java.util.Arrays;
import java.util.List;
import org.minimalj.frontend.Frontend;
import org.minimalj.frontend.action.Action;
import org.minimalj.frontend.impl.json.JsonComponent;
import org.minimalj.frontend.impl.json.JsonFrontend;
import org.minimalj.frontend.impl.json.JsonSearchPanel;
import org.minimalj.frontend.page.IDialog;

public class JsonDialog
extends JsonComponent
implements IDialog {
    public JsonDialog(String title, Frontend.IContent content, Action saveAction, Action[] actions) {
        super("Dialog");
        this.put("title", (Object)title);
        this.put("content", (Object)content);
        List<Object> jsonActions = JsonFrontend.getClientSession().createActions(actions);
        this.put("actions", (Object)jsonActions);
        if (saveAction != null) {
            int saveActionIndex = Arrays.asList(actions).indexOf(saveAction);
            Object jsonSaveAction = saveActionIndex > -1 ? jsonActions.get(saveActionIndex) : JsonFrontend.getClientSession().createAction(saveAction);
            this.put("saveAction", jsonSaveAction);
        }
        JsonFrontend.getClientSession().openDialog(this);
    }

    private JsonDialog(String type, JsonComponent content) {
        super(type);
        this.put("title", (Object)"Search");
        this.put("content", (Object)content);
        JsonFrontend.getClientSession().openDialog(this);
    }

    @Override
    public void closeDialog() {
        JsonFrontend.getClientSession().closeDialog((String)this.get("id"));
    }

    public static class JsonSearchDialog<T>
    extends JsonDialog {
        public JsonSearchDialog(Frontend.Search<T> search, Object[] keys, Frontend.TableActionListener<T> listener) {
            super("SearchDialog", new JsonSearchPanel<T>(search, keys, listener));
        }
    }
}

