/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.json;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.UUID;
import org.minimalj.frontend.Frontend;

public class JsonComponent
extends LinkedHashMap<String, Object>
implements Frontend.IComponent,
Externalizable {
    private static final String ID = "id";
    private static final String TYPE = "type";
    private JsonPropertyListener propertyListener;

    public JsonComponent(String type) {
        this(type, true);
    }

    public JsonComponent(String type, boolean identifiable) {
        this.put(TYPE, (Object)type);
        if (identifiable) {
            this.put(ID, (Object)UUID.randomUUID().toString());
        }
    }

    @Override
    public Object put(String property, Object value) {
        Object oldValue = super.put(property, value);
        this.fireChange(property, value, oldValue);
        return oldValue;
    }

    protected void fireChange(String property, Object value, Object oldValue) {
        if (!Objects.equals(oldValue, value) && this.propertyListener != null) {
            this.propertyListener.propertyChange(this.getId(), property, value);
        }
    }

    Object putSilent(String property, Object value) {
        return super.put(property, value);
    }

    public String getId() {
        return (String)this.get(ID);
    }

    public void setPropertyListener(JsonPropertyListener propertyListener) {
        this.propertyListener = propertyListener;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.explainExternalization();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.explainExternalization();
    }

    private void explainExternalization() {
        throw new RuntimeException("JsonComponent is not meant to be serialized. Does only implement Externalizable to avoid SerialVersionUID in all components");
    }

    public static interface JsonPropertyListener {
        public void propertyChange(String var1, String var2, Object var3);
    }
}

