/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.form.element;

import org.minimalj.frontend.Frontend;
import org.minimalj.frontend.form.element.FormElement;
import org.minimalj.model.EnumUtils;
import org.minimalj.model.Keys;
import org.minimalj.model.Rendering;
import org.minimalj.model.properties.PropertyInterface;
import org.minimalj.util.ChangeListener;

public class TextFormElement
implements FormElement<Object> {
    private final PropertyInterface property;
    protected final Frontend.Input<String> textField;

    public TextFormElement(Object key) {
        this(Keys.getProperty(key));
    }

    public TextFormElement(PropertyInterface property) {
        this.property = property;
        this.textField = Frontend.getInstance().createReadOnlyTextField();
    }

    @Override
    public PropertyInterface getProperty() {
        return this.property;
    }

    @Override
    public Frontend.IComponent getComponent() {
        return this.textField;
    }

    @Override
    public Object getValue() {
        throw new RuntimeException("getObject() on TextElement " + this.getClass().getSimpleName() + " must not be called");
    }

    @Override
    public void setChangeListener(ChangeListener<FormElement<?>> changeListener) {
    }

    @Override
    public void setValue(Object object) {
        if (object instanceof Rendering) {
            Rendering rendering = (Rendering)object;
            this.textField.setValue(rendering.render(Rendering.RenderType.PLAIN_TEXT));
        } else if (object instanceof Enum) {
            this.textField.setValue(EnumUtils.getText((Enum)object));
        } else if (object != null) {
            this.textField.setValue(object.toString());
        } else {
            this.textField.setValue("");
        }
    }
}

