/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.form.element;

import java.util.Arrays;
import org.minimalj.frontend.Frontend;
import org.minimalj.frontend.form.element.AbstractFormElement;
import org.minimalj.model.Keys;
import org.minimalj.model.annotation.AnnotationUtil;

public class PasswordFormElement
extends AbstractFormElement<char[]> {
    private final int maxLength;
    private final Frontend.PasswordField textField;

    public PasswordFormElement(Object key) {
        super(Keys.getProperty(key));
        this.maxLength = AnnotationUtil.getSize(Keys.getProperty(key));
        this.textField = Frontend.getInstance().createPasswordField(this.listener(), this.maxLength);
    }

    @Override
    public Frontend.IComponent getComponent() {
        return this.textField;
    }

    @Override
    public void setValue(char[] value) {
        if (value != null && value.length > this.maxLength) {
            value = Arrays.copyOfRange(value, 0, this.maxLength);
        }
        this.textField.setValue(value);
    }

    @Override
    public char[] getValue() {
        return (char[])this.textField.getValue();
    }
}

