/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.form.element;

import java.util.Random;
import org.minimalj.frontend.form.element.NumberFormElement;
import org.minimalj.model.Keys;
import org.minimalj.model.annotation.Size;
import org.minimalj.model.properties.PropertyInterface;
import org.minimalj.model.validation.InvalidValues;
import org.minimalj.util.mock.Mocking;

public class LongFormElement
extends NumberFormElement<Long>
implements Mocking {
    public LongFormElement(Object key, boolean editable) {
        this(Keys.getProperty(key), editable);
    }

    public LongFormElement(PropertyInterface property, boolean editable) {
        super(property, editable);
    }

    @Override
    public Long parse(String text) {
        if (text != null) {
            try {
                int size;
                long value = Long.parseLong(text);
                if (value < 0L && !this.signed) {
                    return InvalidValues.createInvalidLong(text);
                }
                int n = size = value < 0L ? text.length() - 1 : text.length();
                if (size <= this.size) {
                    return value;
                }
                return InvalidValues.createInvalidLong(text);
            }
            catch (NumberFormatException nfe) {
                return InvalidValues.createInvalidLong(text);
            }
        }
        return null;
    }

    @Override
    public void mock() {
        Random random = new Random();
        long value = random.nextLong();
        if (this.size < Size.LONG) {
            long max = 10L;
            for (int i = 1; i < this.size; ++i) {
                max *= 10L;
            }
            value %= max;
        }
        if (!this.signed && value < 0L) {
            value = -value;
        }
        this.setValue(value);
    }
}

