/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.form.element;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.minimalj.frontend.Frontend;
import org.minimalj.frontend.form.element.FormatFormElement;
import org.minimalj.model.annotation.Size;
import org.minimalj.model.properties.PropertyInterface;
import org.minimalj.model.validation.InvalidValues;
import org.minimalj.util.DateUtils;
import org.minimalj.util.mock.MockDate;

public class LocalTimeFormElement
extends FormatFormElement<LocalTime> {
    private final DateTimeFormatter formatter;
    private final int size;

    public LocalTimeFormElement(PropertyInterface property, boolean editable) {
        super(property, editable);
        this.formatter = DateUtils.getTimeFormatter(property);
        Size sizeAnnotation = property.getAnnotation(Size.class);
        this.size = sizeAnnotation != null ? sizeAnnotation.value() : 5;
    }

    @Override
    protected String getAllowedCharacters(PropertyInterface property) {
        if (this.size > 8) {
            return "01234567890:.";
        }
        return "01234567890:";
    }

    @Override
    protected Frontend.InputType getInputType() {
        return Frontend.InputType.TIME;
    }

    @Override
    protected int getAllowedSize(PropertyInterface property) {
        return DateUtils.getTimeSize(property);
    }

    @Override
    public LocalTime parse(String string) {
        if (string != null) {
            try {
                return LocalTime.parse(string, this.formatter);
            }
            catch (DateTimeParseException iae) {
                return InvalidValues.createInvalidLocalTime(string);
            }
        }
        return null;
    }

    @Override
    public String render(LocalTime value) {
        if (InvalidValues.isInvalid(value)) {
            return this.typed ? InvalidValues.getInvalidValue(value) : null;
        }
        if (value != null) {
            return this.formatter.format(value);
        }
        return null;
    }

    @Override
    public void mock() {
        this.setValue(MockDate.generateRandomTime(this.size));
    }
}

