/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.form.element;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.minimalj.frontend.Frontend;
import org.minimalj.frontend.form.element.FormatFormElement;
import org.minimalj.model.annotation.Size;
import org.minimalj.model.properties.PropertyInterface;
import org.minimalj.model.validation.InvalidValues;
import org.minimalj.util.DateUtils;
import org.minimalj.util.mock.MockDate;

public class LocalDateTimeFormElement
extends FormatFormElement<LocalDateTime> {
    private static final boolean german = Locale.getDefault().getLanguage().equals(new Locale("de").getLanguage());
    private final DateTimeFormatter formatter;
    private final int size;

    public LocalDateTimeFormElement(PropertyInterface property, boolean editable) {
        super(property, editable);
        this.formatter = DateUtils.getTimeFormatter(property);
        Size sizeAnnotation = property.getAnnotation(Size.class);
        this.size = 11 + (sizeAnnotation != null ? sizeAnnotation.value() : 5);
    }

    @Override
    protected String getAllowedCharacters(PropertyInterface property) {
        return german ? "01234567890.: " : null;
    }

    @Override
    protected int getAllowedSize(PropertyInterface property) {
        return german ? this.size : 255;
    }

    @Override
    protected Frontend.InputType getInputType() {
        return Frontend.InputType.DATETIME;
    }

    @Override
    public LocalDateTime parse(String string) {
        if (string != null) {
            try {
                if (this.typed) {
                    return LocalDateTime.parse(string);
                }
                String[] parts = string.split(" ");
                return LocalDateTime.of(DateUtils.parse(parts[0]), LocalTime.parse(parts[1], this.formatter));
            }
            catch (Exception exception) {
                return InvalidValues.createInvalidLocalDateTime(string);
            }
        }
        return null;
    }

    @Override
    public String render(LocalDateTime value) {
        if (InvalidValues.isInvalid(value)) {
            return this.typed ? InvalidValues.getInvalidValue(value) : null;
        }
        if (value != null) {
            if (this.typed) {
                return value.toString();
            }
            return DateUtils.format(value.toLocalDate()) + " " + this.formatter.format(value.toLocalTime());
        }
        return null;
    }

    @Override
    public void mock() {
        this.setValue(LocalDateTime.of(MockDate.generateRandomDate(), MockDate.generateRandomTime(5)));
    }
}

