/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.form.element;

import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import org.minimalj.frontend.Frontend;
import org.minimalj.frontend.form.element.FormatFormElement;
import org.minimalj.model.properties.PropertyInterface;
import org.minimalj.model.validation.InvalidValues;
import org.minimalj.util.DateUtils;
import org.minimalj.util.mock.MockDate;

public class LocalDateFormElement
extends FormatFormElement<LocalDate> {
    private static final boolean german = Locale.getDefault().getLanguage().equals(new Locale("de").getLanguage());

    public LocalDateFormElement(PropertyInterface property, boolean editable) {
        super(property, editable);
    }

    @Override
    protected String getAllowedCharacters(PropertyInterface property) {
        return german ? "01234567890." : null;
    }

    @Override
    protected int getAllowedSize(PropertyInterface property) {
        return german ? 10 : 255;
    }

    @Override
    protected Frontend.InputType getInputType() {
        return Frontend.InputType.DATE;
    }

    @Override
    public LocalDate parse(String string) {
        if (string != null) {
            try {
                if (this.typed) {
                    return LocalDate.parse(string);
                }
                return DateUtils.parse(string);
            }
            catch (DateTimeParseException x) {
                return InvalidValues.createInvalidLocalDate(string);
            }
        }
        return null;
    }

    @Override
    public String render(LocalDate value) {
        if (InvalidValues.isInvalid(value)) {
            return this.typed ? InvalidValues.getInvalidValue(value) : null;
        }
        if (value != null) {
            if (this.typed) {
                return value.toString();
            }
            return DateUtils.format(value);
        }
        return null;
    }

    @Override
    public void mock() {
        this.setValue(MockDate.generateRandomDate());
    }
}

