/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.form.element;

import java.util.List;
import org.minimalj.frontend.action.Action;
import org.minimalj.frontend.editor.Editor;
import org.minimalj.frontend.form.Form;
import org.minimalj.frontend.form.element.AbstractObjectFormElement;
import org.minimalj.model.properties.PropertyInterface;
import org.minimalj.util.CloneHelper;
import org.minimalj.util.GenericUtils;

public abstract class ListFormElement<T>
extends AbstractObjectFormElement<List<T>> {
    public ListFormElement(PropertyInterface property) {
        this(property, true);
    }

    public ListFormElement(PropertyInterface property, boolean editable) {
        super(property, editable);
    }

    @Override
    protected void show(List<T> objects) {
        for (T entry : objects) {
            this.showEntry(entry);
        }
    }

    protected abstract void showEntry(T var1);

    protected abstract Form<T> createForm(boolean var1);

    protected Action getEditorAction() {
        throw new RuntimeException(this.getClass().getSimpleName() + " must not use getEditorAction. Please use an extension of EditListEntryAction");
    }

    public class ListEntryEditor
    extends ListFormElementEditor {
        private final T originalEntry;

        public ListEntryEditor(T originalEntry) {
            this.originalEntry = originalEntry;
        }

        @Override
        protected T createObject() {
            return CloneHelper.clone(this.originalEntry);
        }

        @Override
        protected Form<T> createForm() {
            return ListFormElement.this.createForm(true);
        }

        @Override
        public Void save(T entry) {
            this.editEntry(this.originalEntry, entry);
            return null;
        }

        protected void editEntry(T originalEntry, T entry) {
            CloneHelper.deepCopy(entry, originalEntry);
        }

        @Override
        protected void finished(Void result) {
            ListFormElement.this.handleChange();
        }
    }

    public class AddListEntryEditor
    extends ListFormElementEditor {
        public AddListEntryEditor() {
        }

        public AddListEntryEditor(String name) {
            super(name);
        }

        @Override
        protected T createObject() {
            Class<?> clazz = GenericUtils.getGenericClass(ListFormElement.this.getClass());
            Object newInstance = CloneHelper.newInstance(clazz);
            return newInstance;
        }

        @Override
        protected Form<T> createForm() {
            return ListFormElement.this.createForm(true);
        }

        @Override
        public Void save(T entry) {
            this.addEntry(entry);
            return null;
        }

        protected void addEntry(T entry) {
            ((List)ListFormElement.this.getValue()).add(entry);
        }

        @Override
        protected void finished(Void result) {
            ListFormElement.this.handleChange();
        }
    }

    private abstract class ListFormElementEditor
    extends Editor<T, Void> {
        public ListFormElementEditor() {
            ListFormElement.this.assertEditable(this);
        }

        public ListFormElementEditor(String name) {
            super(name);
            ListFormElement.this.assertEditable(this);
        }

        @Override
        protected Class<?> getEditedClass() {
            return GenericUtils.getGenericClass(ListFormElement.this.getClass());
        }
    }
}

