/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.form.element;

import java.util.Random;
import org.minimalj.frontend.form.element.NumberFormElement;
import org.minimalj.model.Keys;
import org.minimalj.model.annotation.Size;
import org.minimalj.model.properties.PropertyInterface;
import org.minimalj.model.validation.InvalidValues;
import org.minimalj.util.mock.Mocking;

public class IntegerFormElement
extends NumberFormElement<Integer>
implements Mocking {
    public IntegerFormElement(Object key, boolean editable) {
        this(Keys.getProperty(key), editable);
    }

    public IntegerFormElement(PropertyInterface property, boolean editable) {
        super(property, editable);
    }

    @Override
    public Integer parse(String text) {
        if (text != null) {
            try {
                int size;
                int value = Integer.parseInt(text);
                if (value < 0 && !this.signed) {
                    return InvalidValues.createInvalidInteger(text);
                }
                int n = size = value < 0 ? text.length() - 1 : text.length();
                if (size <= this.size) {
                    return value;
                }
                return InvalidValues.createInvalidInteger(text);
            }
            catch (NumberFormatException nfe) {
                return InvalidValues.createInvalidInteger(text);
            }
        }
        return null;
    }

    @Override
    public void mock() {
        Random random = new Random();
        int value = random.nextInt();
        if (this.size < Size.INTEGER) {
            int max = 10;
            for (int i = 1; i < this.size; ++i) {
                max *= 10;
            }
            value %= max;
        }
        if (!this.signed && value < 0) {
            value = -value;
        }
        this.setValue(value);
    }
}

