/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.form.element;

import java.util.logging.Logger;
import org.minimalj.application.DevMode;
import org.minimalj.frontend.Frontend;
import org.minimalj.frontend.action.Action;
import org.minimalj.frontend.form.element.AbstractFormElement;
import org.minimalj.frontend.form.element.Enable;
import org.minimalj.frontend.page.Page;
import org.minimalj.frontend.page.PageAction;
import org.minimalj.model.Rendering;
import org.minimalj.model.properties.PropertyInterface;
import org.minimalj.util.CloneHelper;
import org.minimalj.util.GenericUtils;

public abstract class AbstractObjectFormElement<T>
extends AbstractFormElement<T>
implements Enable {
    private static final Logger logger = Logger.getLogger(AbstractObjectFormElement.class.getName());
    private final boolean editable;
    private final Frontend.IList list;
    private T object;

    public AbstractObjectFormElement(PropertyInterface property, boolean editable) {
        super(property);
        this.editable = editable;
        this.list = editable ? Frontend.getInstance().createList(this.getActions()) : Frontend.getInstance().createList(new Action[0]);
    }

    protected final boolean isEditable() {
        return this.editable;
    }

    @Override
    public T getValue() {
        return this.object;
    }

    @Override
    public void setValue(T object) {
        this.object = object;
        this.handleChange();
    }

    @Override
    public Frontend.IComponent getComponent() {
        return this.list;
    }

    protected T createObject() {
        if (this.getValue() != null) {
            return CloneHelper.clone(this.getValue());
        }
        return (T)CloneHelper.newInstance(GenericUtils.getGenericClass(this.getClass()));
    }

    protected void assertEditable(Object object) {
        if (!this.isEditable()) {
            String msg = object.getClass().getSimpleName() + " should not be used if " + AbstractObjectFormElement.class.getSimpleName() + " is not editable";
            if (DevMode.isActive()) {
                throw new IllegalArgumentException(msg);
            }
            logger.warning(msg);
        }
    }

    protected void handleChange() {
        this.display();
        super.fireChange();
    }

    protected void display() {
        this.list.clear();
        if (this.object != null) {
            this.show(this.object);
        }
    }

    protected abstract void show(T var1);

    protected void add(Rendering rendering, Action ... actions) {
        this.list.add(Frontend.getInstance().createText(rendering), actions);
    }

    protected void add(Object object, Action ... actions) {
        this.add(object.toString(), actions);
    }

    protected void add(String text, Action ... actions) {
        this.list.add(Frontend.getInstance().createText(text), actions);
    }

    protected void add(Action action) {
        this.list.add(Frontend.getInstance().createText(action), new Action[0]);
    }

    protected void add(String text, Page linkedPage) {
        this.list.add(Frontend.getInstance().createText(new PageAction(linkedPage, text)), new Action[0]);
    }

    protected void add(Rendering rendering, Page linkedPage) {
        this.list.add(Frontend.getInstance().createText(rendering), new PageAction(linkedPage));
    }

    protected void addTextArea(String text, Action ... actions) {
        Frontend.Input<String> textArea = Frontend.getInstance().createAreaField(text.length(), null, this.listener());
        textArea.setValue(text);
        textArea.setEditable(false);
        this.list.add(textArea, actions);
    }

    protected Action[] getActions() {
        return null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.list.setEnabled(enabled);
    }
}

