/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.form;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.minimalj.frontend.Frontend;
import org.minimalj.frontend.form.element.BigDecimalFormElement;
import org.minimalj.frontend.form.element.CheckBoxFormElement;
import org.minimalj.frontend.form.element.CodeFormElement;
import org.minimalj.frontend.form.element.Enable;
import org.minimalj.frontend.form.element.EnumFormElement;
import org.minimalj.frontend.form.element.EnumSetFormElement;
import org.minimalj.frontend.form.element.FormElement;
import org.minimalj.frontend.form.element.IntegerFormElement;
import org.minimalj.frontend.form.element.LocalDateFormElement;
import org.minimalj.frontend.form.element.LocalDateTimeFormElement;
import org.minimalj.frontend.form.element.LocalTimeFormElement;
import org.minimalj.frontend.form.element.LongFormElement;
import org.minimalj.frontend.form.element.StringFormElement;
import org.minimalj.frontend.form.element.TextFormElement;
import org.minimalj.frontend.form.element.TypeUnknownFormElement;
import org.minimalj.model.Code;
import org.minimalj.model.Keys;
import org.minimalj.model.annotation.Enabled;
import org.minimalj.model.properties.ChainedProperty;
import org.minimalj.model.properties.Properties;
import org.minimalj.model.properties.PropertyInterface;
import org.minimalj.model.validation.ValidationMessage;
import org.minimalj.util.ChangeListener;
import org.minimalj.util.CloneHelper;
import org.minimalj.util.ExceptionUtils;
import org.minimalj.util.mock.Mocking;
import org.minimalj.util.resources.Resources;

public class Form<T> {
    private static Logger logger = Logger.getLogger(Form.class.getSimpleName().toUpperCase());
    public static final boolean EDITABLE = true;
    public static final boolean READ_ONLY = false;
    protected final boolean editable;
    private final int columns;
    private final Frontend.FormContent formContent;
    private final LinkedHashMap<PropertyInterface, FormElement<?>> elements = new LinkedHashMap();
    private final FormPanelChangeListener formPanelChangeListener = new FormPanelChangeListener();
    private ChangeListener<Form<?>> changeListener;
    private boolean changeFromOutsite;
    private final Map<String, List<PropertyInterface>> dependencies = new HashMap<String, List<PropertyInterface>>();
    private final Map<PropertyInterface, Map<PropertyInterface, PropertyUpdater>> propertyUpdater = new HashMap<PropertyInterface, Map<PropertyInterface, PropertyUpdater>>();
    private T object;

    public Form() {
        this(true);
    }

    public Form(boolean editable) {
        this(editable, 1);
    }

    public Form(int columns) {
        this(true, columns);
    }

    public Form(boolean editable, int columns) {
        this.editable = editable;
        this.columns = columns;
        this.formContent = Frontend.getInstance().createFormContent(columns, this.getColumnWidthPercentage());
    }

    protected int getColumnWidthPercentage() {
        return 100;
    }

    public Frontend.FormContent getContent() {
        return this.formContent;
    }

    public FormElement<?> createElement(Object key) {
        FormElement<?> element;
        if (key == null) {
            throw new NullPointerException("Key must not be null");
        }
        if (key instanceof FormElement) {
            element = (FormElement<?>)key;
            PropertyInterface property = element.getProperty();
            if (property == null) {
                throw new IllegalArgumentException(Frontend.IComponent.class.getSimpleName() + " has no key");
            }
        } else {
            PropertyInterface property = Keys.getProperty(key);
            if (property == null) {
                throw new IllegalArgumentException("" + key);
            }
            element = this.createElement(property);
        }
        return element;
    }

    protected FormElement<?> createElement(PropertyInterface property) {
        boolean editable;
        Class<?> fieldClass = property.getClazz();
        boolean bl = editable = this.editable && !property.isFinal();
        if (fieldClass == String.class) {
            return editable ? new StringFormElement(property) : new TextFormElement(property);
        }
        if (fieldClass == Boolean.class) {
            return new CheckBoxFormElement(property, editable);
        }
        if (fieldClass == Integer.class) {
            return new IntegerFormElement(property, editable);
        }
        if (fieldClass == Long.class) {
            return new LongFormElement(property, editable);
        }
        if (fieldClass == BigDecimal.class) {
            return new BigDecimalFormElement(property, editable);
        }
        if (fieldClass == LocalDate.class) {
            return new LocalDateFormElement(property, editable);
        }
        if (fieldClass == LocalTime.class) {
            return new LocalTimeFormElement(property, editable);
        }
        if (fieldClass == LocalDateTime.class) {
            return new LocalDateTimeFormElement(property, editable);
        }
        if (Code.class.isAssignableFrom(fieldClass)) {
            return editable ? new CodeFormElement(property) : new TextFormElement(property);
        }
        if (Enum.class.isAssignableFrom(fieldClass)) {
            return editable ? new EnumFormElement(property) : new TextFormElement(property);
        }
        if (fieldClass == Set.class) {
            return new EnumSetFormElement(property, this.editable);
        }
        logger.severe("No FormElement could be created for: " + property.getName() + " of class " + fieldClass.getName());
        return new TypeUnknownFormElement(property);
    }

    public void line(Object key) {
        FormElement<?> element = this.createElement(key);
        this.add(element, this.columns);
    }

    public void line(Object ... keys) {
        if (keys.length > this.columns) {
            logger.severe("This form was constructed for " + this.columns + " column(s) but should be filled with " + keys.length + " form elements");
            logger.fine("The solution is most probably to add/set the correct number of columns when calling the Form constructor");
            throw new IllegalArgumentException("Not enough columns (" + this.columns + ") for form elements (" + keys.length + ")");
        }
        int span = this.columns / keys.length;
        int rest = this.columns;
        for (int i = 0; i < keys.length; ++i) {
            Object key = keys[i];
            FormElement<?> element = this.createElement(key);
            this.add(element, i < keys.length - 1 ? span : rest);
            rest -= span;
        }
    }

    public void lineWithoutCaption(Object key) {
        FormElement<?> element = this.createElement(key);
        this.formContent.add(element.getComponent());
        this.registerNamedElement(element);
    }

    private void add(FormElement<?> element, int span) {
        String captionText = this.caption(element);
        this.formContent.add(captionText, element.getComponent(), span);
        this.registerNamedElement(element);
        this.addDependencies(element);
    }

    public void text(String text) {
        Frontend.IComponent label = Frontend.getInstance().createText(text);
        this.formContent.add(label);
    }

    public void addTitle(String text) {
        Frontend.IComponent label = Frontend.getInstance().createTitle(text);
        this.formContent.add(label);
    }

    public void addDependecy(Object from, Object ... to) {
        PropertyInterface fromProperty = Keys.getProperty(from);
        if (!this.dependencies.containsKey(fromProperty.getPath())) {
            this.dependencies.put(fromProperty.getPath(), new ArrayList());
        }
        List<PropertyInterface> list = this.dependencies.get(fromProperty.getPath());
        for (Object key : to) {
            list.add(Keys.getProperty(key));
        }
    }

    private void addDependecy(PropertyInterface fromProperty, PropertyInterface to) {
        if (!this.dependencies.containsKey(fromProperty.getPath())) {
            this.dependencies.put(fromProperty.getPath(), new ArrayList());
        }
        List<PropertyInterface> list = this.dependencies.get(fromProperty.getPath());
        list.add(to);
    }

    public <FROM, TO> void addDependecy(FROM from, PropertyUpdater<FROM, TO, T> updater, TO to) {
        PropertyInterface fromProperty = Keys.getProperty(from);
        if (!this.propertyUpdater.containsKey(fromProperty)) {
            this.propertyUpdater.put(fromProperty, new HashMap());
        }
        PropertyInterface toProperty = Keys.getProperty(to);
        this.propertyUpdater.get(fromProperty).put(toProperty, updater);
        this.addDependecy(from, to);
    }

    private void registerNamedElement(FormElement<?> field) {
        this.elements.put(field.getProperty(), field);
        field.setChangeListener(this.formPanelChangeListener);
    }

    private void addDependencies(FormElement<?> field) {
        List<PropertyInterface> dependencies = Keys.getDependencies(field.getProperty());
        for (PropertyInterface dependency : dependencies) {
            this.addDependecy(dependency, field.getProperty());
        }
    }

    public final void mock() {
        this.changeFromOutsite = true;
        try {
            this.fillWithDemoData(this.object);
        }
        catch (Exception x) {
            logger.log(Level.SEVERE, "Fill with demo data failed", x);
        }
        finally {
            this.readValueFromObject();
            this.changeFromOutsite = false;
        }
    }

    protected void fillWithDemoData(T object) {
        for (FormElement<?> field : this.elements.values()) {
            PropertyInterface property = field.getProperty();
            if (!(field instanceof Mocking)) continue;
            Mocking demoEnabledElement = (Mocking)((Object)field);
            demoEnabledElement.mock();
            property.setValue(object, field.getValue());
        }
    }

    protected String caption(FormElement<?> field) {
        return Resources.getPropertyName(field.getProperty());
    }

    public Collection<PropertyInterface> getProperties() {
        return this.elements.keySet();
    }

    private void set(PropertyInterface property, Object value) {
        FormElement<?> element = this.elements.get(property);
        try {
            element.setValue(value);
        }
        catch (Exception x) {
            ExceptionUtils.logReducedStackTrace(logger, x);
        }
    }

    private void setValidationMessage(PropertyInterface property, List<String> validationMessages) {
        FormElement<?> field = this.elements.get(property);
        this.formContent.setValidationMessages(field.getComponent(), validationMessages);
    }

    public void setObject(T object) {
        if (this.editable && this.changeListener == null) {
            throw new IllegalStateException("Listener has to be set on a editable Form");
        }
        this.changeFromOutsite = true;
        this.object = object;
        this.readValueFromObject();
        this.changeFromOutsite = false;
    }

    private void readValueFromObject() {
        for (PropertyInterface property : this.getProperties()) {
            Object propertyValue = property.getValue(this.object);
            this.set(property, propertyValue);
        }
        this.updateEnable();
    }

    private String getName(FormElement<?> field) {
        PropertyInterface property = field.getProperty();
        return property.getName();
    }

    public void setChangeListener(ChangeListener<Form<?>> changeListener) {
        if (changeListener == null) {
            throw new IllegalArgumentException("Listener on Form must not be null");
        }
        if (this.changeListener != null) {
            throw new IllegalStateException("Listener on Form cannot be changed");
        }
        this.changeListener = changeListener;
    }

    private void updateEnable() {
        for (Map.Entry<PropertyInterface, FormElement<?>> element : this.elements.entrySet()) {
            PropertyInterface property = element.getKey();
            Enabled enabledAnnotation = property.getAnnotation(Enabled.class);
            if (element.getValue() instanceof Enable) {
                boolean enabled = true;
                if (property instanceof ChainedProperty) {
                    enabled = ((ChainedProperty)property).isAvailableFor(this.object);
                }
                if (enabled && enabledAnnotation != null) {
                    String methodName = enabledAnnotation.value();
                    boolean invert = methodName.startsWith("!");
                    if (invert) {
                        methodName = methodName.substring(1);
                    }
                    try {
                        Object o = this.findParentObject(property);
                        Class<?> clazz = o.getClass();
                        Method method = clazz.getMethod(methodName, new Class[0]);
                        enabled = (Boolean)method.invoke(o, new Object[0]) ^ invert;
                    }
                    catch (Exception x) {
                        String fieldName = property.getName();
                        if (!fieldName.equals(property.getPath())) {
                            fieldName = fieldName + " (" + property.getPath() + ")";
                        }
                        logger.log(Level.SEVERE, "Update enable of " + fieldName + " failed", x);
                    }
                }
                ((Enable)((Object)element.getValue())).setEnabled(enabled);
                continue;
            }
            if (enabledAnnotation == null) continue;
            if (this.editable) {
                logger.severe("element " + property.getPath() + " should implement Enable");
                continue;
            }
            logger.fine("element " + property.getPath() + " should maybe implement Enable");
        }
    }

    public void indicate(List<ValidationMessage> validationMessages) {
        for (PropertyInterface property : this.getProperties()) {
            List<String> filteredValidationMessages = ValidationMessage.filterValidationMessage(validationMessages, property);
            this.setValidationMessage(property, filteredValidationMessages);
        }
    }

    private Object findParentObject(PropertyInterface property) {
        Object result = this.object;
        String fieldPath = property.getPath();
        while (fieldPath.indexOf(".") > -1) {
            int pos = property.getPath().indexOf(".");
            PropertyInterface p2 = Properties.getProperty(result.getClass(), fieldPath.substring(0, pos));
            result = p2.getValue(result);
            fieldPath = fieldPath.substring(pos + 1);
        }
        return result;
    }

    private class FormPanelChangeListener
    implements ChangeListener<FormElement<?>> {
        private FormPanelChangeListener() {
        }

        @Override
        public void changed(FormElement<?> changedField) {
            if (Form.this.changeFromOutsite) {
                return;
            }
            if (Form.this.changeListener == null) {
                if (Form.this.editable) {
                    logger.severe("Editable Form must have a listener");
                }
                return;
            }
            logger.fine("ChangeEvent from " + Form.this.getName(changedField));
            PropertyInterface property = changedField.getProperty();
            Object newValue = changedField.getValue();
            this.executeUpdater(property, newValue);
            property.setValue(Form.this.object, newValue);
            this.refreshDependendFields(property);
            Form.this.updateEnable();
            Form.this.changeListener.changed(Form.this);
        }

        private void refreshDependendFields(PropertyInterface property) {
            if (Form.this.dependencies.containsKey(property.getPath())) {
                List dependendProperties = (List)Form.this.dependencies.get(property.getPath());
                for (PropertyInterface dependendProperty : dependendProperties) {
                    for (FormElement formElement : Form.this.elements.values()) {
                        String dependedPath;
                        String formElementPath = formElement.getProperty().getPath();
                        if (!formElementPath.equals(dependedPath = dependendProperty.getPath()) && (!formElementPath.startsWith(dependedPath) || formElementPath.charAt(dependedPath.length()) != '.')) continue;
                        Object newDependedValue = formElement.getProperty().getValue(Form.this.object);
                        formElement.setValue(newDependedValue);
                    }
                }
            }
        }

        private void executeUpdater(PropertyInterface property, Object value) {
            if (Form.this.propertyUpdater.containsKey(property)) {
                Map updaters = (Map)Form.this.propertyUpdater.get(property);
                for (Map.Entry entry : updaters.entrySet()) {
                    Object ret = ((PropertyUpdater)entry.getValue()).update(value, CloneHelper.clone(Form.this.object));
                    ((PropertyInterface)entry.getKey()).setValue(Form.this.object, ret);
                }
            }
        }
    }

    public static interface PropertyUpdater<FROM, TO, EDIT_OBJECT> {
        public TO update(FROM var1, EDIT_OBJECT var2);
    }
}

