/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend;

import java.util.List;
import java.util.Optional;
import org.minimalj.application.Application;
import org.minimalj.application.Configuration;
import org.minimalj.backend.Backend;
import org.minimalj.frontend.action.Action;
import org.minimalj.frontend.page.IDialog;
import org.minimalj.frontend.page.Page;
import org.minimalj.frontend.page.PageManager;
import org.minimalj.model.Rendering;

public abstract class Frontend {
    private static Frontend instance;

    public static Frontend getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Frontend has to be initialized");
        }
        return instance;
    }

    public static void setInstance(Frontend frontend) {
        if (instance != null) {
            throw new IllegalStateException("Frontend cannot be changed");
        }
        if (frontend == null) {
            throw new IllegalArgumentException("Frontend cannot be null");
        }
        instance = frontend;
    }

    public static boolean isAvailable() {
        return instance != null;
    }

    public static boolean loginAtStart() {
        boolean loginAtStart;
        boolean bl = loginAtStart = Application.getInstance().isLoginRequired() || Configuration.get("MjLoginAtStart", "false").equals("true");
        if (loginAtStart && !Backend.getInstance().isAuthenticationActive()) {
            throw new IllegalStateException("Login required but authorization is not configured!");
        }
        return loginAtStart;
    }

    public Optional<Input<String>> createInput(int maxLength, InputType inputType, InputComponentListener changeListener) {
        return Optional.empty();
    }

    public abstract IComponent createText(String var1);

    public abstract IComponent createText(Action var1);

    public abstract IComponent createText(Rendering var1);

    public abstract IComponent createTitle(String var1);

    public abstract Input<String> createReadOnlyTextField();

    public abstract Input<String> createTextField(int var1, String var2, Search<String> var3, InputComponentListener var4);

    public abstract Input<String> createAreaField(int var1, String var2, InputComponentListener var3);

    public abstract PasswordField createPasswordField(InputComponentListener var1, int var2);

    public abstract IList createList(Action ... var1);

    public abstract <T> Input<T> createComboBox(List<T> var1, InputComponentListener var2);

    public abstract Input<Boolean> createCheckBox(InputComponentListener var1, String var2);

    public abstract Input<byte[]> createImage(int var1, InputComponentListener var2);

    public abstract <T> Input<T> createLookup(InputComponentListener var1, Search<T> var2, Object[] var3);

    public abstract IComponent createComponentGroup(IComponent ... var1);

    public abstract FormContent createFormContent(int var1, int var2);

    public abstract SwitchContent createSwitchContent();

    public abstract <T> ITable<T> createTable(Object[] var1, boolean var2, TableActionListener<T> var3);

    public abstract IContent createHtmlContent(String var1);

    public abstract PageManager getPageManager();

    public static void show(Page page) {
        Frontend.getInstance().getPageManager().show(page);
    }

    public static void showDetail(Page mainPage, Page detail) {
        Frontend.getInstance().getPageManager().showDetail(mainPage, detail);
    }

    public static void hideDetail(Page page) {
        Frontend.getInstance().getPageManager().hideDetail(page);
    }

    public static boolean isDetailShown(Page page) {
        return Frontend.getInstance().getPageManager().isDetailShown(page);
    }

    public static IDialog showDialog(String title, IContent content, Action saveAction, Action closeAction, Action ... actions) {
        return Frontend.getInstance().getPageManager().showDialog(title, content, saveAction, closeAction, actions);
    }

    public static <T> IDialog showSearchDialog(Search<T> index, Object[] keys, TableActionListener<T> listener) {
        return Frontend.getInstance().getPageManager().showSearchDialog(index, keys, listener);
    }

    public static void showMessage(String text) {
        Frontend.getInstance().getPageManager().showMessage(text);
    }

    public static void showError(String text) {
        Frontend.getInstance().getPageManager().showError(text);
    }

    public static interface TableActionListener<U> {
        default public void selectionChanged(List<U> selectedObjects) {
        }

        default public void action(U selectedObject) {
        }
    }

    public static interface ITable<T>
    extends IContent {
        public void setObjects(List<T> var1);
    }

    public static interface SwitchContent
    extends IContent {
        public void show(IContent var1);
    }

    public static interface FormContent
    extends IContent {
        public void add(IComponent var1);

        public void add(String var1, IComponent var2, int var3);

        public void setValidationMessages(IComponent var1, List<String> var2);
    }

    public static interface IContent {
    }

    public static interface Search<S> {
        public List<S> search(String var1);
    }

    public static interface InputComponentListener {
        public void changed(IComponent var1);
    }

    public static interface IList
    extends IComponent {
        public void setEnabled(boolean var1);

        public void clear();

        public void add(IComponent var1, Action ... var2);
    }

    public static enum InputType {
        TEXT,
        EMAIL,
        URL,
        TEL,
        NUMBER,
        DATE,
        TIME,
        DATETIME;

    }

    public static interface PasswordField
    extends Input<char[]> {
    }

    public static interface Input<T>
    extends IComponent {
        public void setValue(T var1);

        public T getValue();

        public void setEditable(boolean var1);
    }

    public static interface IComponent {
    }
}

