/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.backend;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.minimalj.application.Application;
import org.minimalj.application.Configuration;
import org.minimalj.backend.Backend;
import org.minimalj.security.Subject;
import org.minimalj.transaction.InputStreamTransaction;
import org.minimalj.transaction.OutputStreamTransaction;
import org.minimalj.transaction.Transaction;
import org.minimalj.util.LoggingRuntimeException;
import org.minimalj.util.SerializationContainer;
import org.minimalj.util.UnclosingOutputStream;

public class SocketBackendServer {
    private static final Logger LOG = Logger.getLogger(SocketBackendServer.class.getName());
    private final int port;
    private final ThreadPoolExecutor executor;

    public SocketBackendServer(int port) {
        this.port = port;
        this.executor = new ThreadPoolExecutor(10, 30, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public void run() {
        Thread.currentThread().setName("MjServer");
        try (ServerSocket serverSocket = new ServerSocket(this.port);){
            this.accecptInvocations(serverSocket);
        }
        catch (IOException iox) {
            throw new LoggingRuntimeException(iox, LOG, "Could not create server socket");
        }
    }

    private void accecptInvocations(ServerSocket serverSocket) {
        while (true) {
            try {
                while (true) {
                    Socket socket = serverSocket.accept();
                    SocketBackendRunnable runnable = new SocketBackendRunnable(socket);
                    this.executor.execute(runnable);
                }
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Server socket couldn't accept connection", e);
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) {
        Application.initApplication(args);
        String backendPort = Configuration.get("MjBackendPort", "8020");
        int port = Integer.valueOf(backendPort);
        new SocketBackendServer(port).run();
    }

    private static class SocketBackendRunnable
    implements Runnable {
        private final Socket socket;

        public SocketBackendRunnable(Socket socket) {
            this.socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try (ObjectInputStream ois = new ObjectInputStream(this.socket.getInputStream());){
                Serializable securityToken = (Serializable)ois.readObject();
                if (Backend.getInstance().isAuthenticationActive()) {
                    Subject subject = Backend.getInstance().getAuthentication().getUserByToken(securityToken);
                    Subject.setCurrent(subject);
                }
                Transaction transaction = (Transaction)ois.readObject();
                Serializable wrappedResult = null;
                if (transaction instanceof InputStreamTransaction) {
                    InputStreamTransaction inputStreamTransaction = (InputStreamTransaction)transaction;
                    inputStreamTransaction.setStream(ois);
                }
                try (ObjectOutputStream oos = new ObjectOutputStream(this.socket.getOutputStream());){
                    if (transaction instanceof OutputStreamTransaction) {
                        OutputStreamTransaction outputStreamTransaction = (OutputStreamTransaction)transaction;
                        outputStreamTransaction.setStream(new UnclosingOutputStream(oos));
                    }
                    try {
                        Object result = Backend.execute(transaction);
                        wrappedResult = SerializationContainer.wrap(result);
                    }
                    catch (Exception exception) {
                        LOG.log(Level.SEVERE, "Exception in Transaction", exception);
                        oos.writeObject(exception.getMessage());
                        if (oos != null) {
                            if (var8_11 != null) {
                                try {
                                    oos.close();
                                }
                                catch (Throwable throwable) {
                                    var8_11.addSuppressed(throwable);
                                }
                            } else {
                                oos.close();
                            }
                        }
                        if (ois != null) {
                            if (var2_4 != null) {
                                try {
                                    ois.close();
                                }
                                catch (Throwable throwable) {
                                    var2_4.addSuppressed(throwable);
                                }
                            } else {
                                ois.close();
                            }
                        }
                        Subject.setCurrent(null);
                        return;
                    }
                    oos.writeObject(null);
                    oos.writeObject(wrappedResult);
                }
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Could not create ObjectInputStream from socket", e);
            }
            catch (ClassNotFoundException e) {
                LOG.log(Level.SEVERE, "Could not execute transaction", e);
            }
            finally {
                Subject.setCurrent(null);
            }
        }
    }
}

