/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.application;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Logger;
import org.minimalj.application.ThreadLocalApplication;
import org.minimalj.frontend.action.Action;
import org.minimalj.frontend.impl.nanoserver.NanoWebServer;
import org.minimalj.frontend.page.EmptyPage;
import org.minimalj.frontend.page.Page;
import org.minimalj.util.StringUtils;
import org.minimalj.util.resources.Resources;

public abstract class Application {
    private static Application instance;

    public Application() {
        for (String resourceBundleName : this.getResourceBundleNames()) {
            Resources.addResourceBundleName(resourceBundleName);
        }
    }

    public static Application getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Application has to be initialized");
        }
        return instance;
    }

    public static void setInstance(Application application) {
        if (instance != null) {
            throw new IllegalStateException("Application cannot be changed");
        }
        if (application == null) {
            throw new IllegalArgumentException("Application cannot be null");
        }
        instance = application;
    }

    public static void setThreadInstance(Application application) {
        if (instance == null) {
            instance = new ThreadLocalApplication();
        } else if (!(instance instanceof ThreadLocalApplication)) {
            throw new IllegalStateException();
        }
        ((ThreadLocalApplication)instance).setCurrentApplication(application);
    }

    public static void initApplication(String ... args) {
        if (args.length < 1) {
            System.err.println("Please specify an Application as argument");
            System.exit(-1);
        }
        Application.setInstance(Application.createApplicationByClassName(args[0]));
    }

    private static Application createApplicationByClassName(String applicationClassName) {
        Object application;
        Class<?> applicationClass;
        try {
            applicationClass = Class.forName(applicationClassName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find Application class: " + applicationClassName);
        }
        try {
            application = applicationClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Could not instantiate Application class: " + applicationClassName, e);
        }
        if (!(application instanceof Application)) {
            throw new IllegalArgumentException("Class " + applicationClassName + " doesn't extend Application");
        }
        return (Application)application;
    }

    protected Set<String> getResourceBundleNames() {
        try {
            ResourceBundle.getBundle(this.getClass().getName());
            return Collections.singleton(this.getClass().getName());
        }
        catch (MissingResourceException x) {
            Logger logger = Logger.getLogger(Application.class.getName());
            logger.warning("Missing the default ResourceBundle for " + this.getClass().getName());
            logger.fine("The default ResourceBundle has the same name as the Application that is launched.");
            logger.fine("See the MjExampleApplication.java and MjExampleApplication.properties");
            return Collections.emptySet();
        }
    }

    public Class<?>[] getEntityClasses() {
        return new Class[0];
    }

    public String getName() {
        if (Resources.isAvailable("Application.name")) {
            return Resources.getString("Application.name");
        }
        return this.getClass().getSimpleName();
    }

    public InputStream getIcon() {
        String applicationIconName = Resources.isAvailable("Application.icon") ? Resources.getString("Application.icon") : this.getClass().getSimpleName() + ".png";
        InputStream icon = this.getClass().getResourceAsStream(applicationIconName);
        if (icon == null) {
            icon = this.getClass().getResourceAsStream("/" + applicationIconName);
        }
        return icon;
    }

    public Page createSearchPage(String query) {
        return new EmptyPage();
    }

    public boolean hasSearchPages() {
        try {
            return this.getClass().getMethod("createSearchPage", String.class).getDeclaringClass() != Application.class;
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public Page createDefaultPage() {
        return new EmptyPage();
    }

    public boolean isLoginRequired() {
        return false;
    }

    public List<Action> getNavigation() {
        return Collections.emptyList();
    }

    public static void main(String ... args) {
        Logger logger = Logger.getLogger(Application.class.getName());
        logger.warning("Starting the Application class is not the intended way to start a Minimal-J application");
        String mainClass = System.getProperty("sun.java.command");
        if (mainClass == null) {
            logger.severe("and the started application could not be retrieved. Nothing started.");
        } else if (Application.class.getName().equals(mainClass)) {
            logger.severe("and starting the Application class doesn't work at all. Nothing started.");
        } else {
            NanoWebServer.main(mainClass);
        }
    }

    static {
        if (StringUtils.isEmpty(System.getProperty("java.util.logging.SimpleFormatter.format"))) {
            System.setProperty("java.util.logging.SimpleFormatter.format", "%1$tF %1$tT:%1$tL %4$-13s %3$-4s %5$s %6$s%n");
        }
    }
}

