/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop.viewer;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import jrdesktop.SysTray;
import jrdesktop.main;
import jrdesktop.viewer.Config;
import jrdesktop.viewer.Recorder;

public class ViewerGUI
extends JFrame {
    private Recorder recorder;
    private JScrollPane jScrollPane1;

    public ViewerGUI(Recorder recorder) {
        this.recorder = recorder;
        this.initComponents();
        this.jScrollPane1.setViewportView(recorder.screenPlayer);
        this.setVisible(true);
    }

    public void Start() {
        if (this.recorder.isRecording()) {
            this.recorder.Stop();
        } else {
            this.recorder.Start();
        }
        if (this.recorder.isRecording()) {
            this.setIconImage(new ImageIcon(main.ALIVE_ICON).getImage());
            this.setTitle("jrdesktop Viewer [" + Config.server_address + "]");
        } else {
            this.setTitle("jrdesktop Viewer");
            this.setIconImage(new ImageIcon(main.WAIT_ICON).getImage());
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.setDefaultCloseOperation(0);
        this.setTitle(" jrdesktop Viewer");
        this.setIconImage(new ImageIcon(main.WAIT_ICON).getImage());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ViewerGUI.this.formWindowClosing(evt);
            }
        });
        this.jScrollPane1.setFocusable(false);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 892, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 466, Short.MAX_VALUE));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 900) / 2, (screenSize.height - 500) / 2, 900, 500);
    }

    private void formWindowClosing(WindowEvent evt) {
        if (evt.getID() == 201) {
            if (JOptionPane.showConfirmDialog(null, "Exit Viewer ?", "Confirm Dialog", 2) == 0) {
                if (this.recorder.isRecording()) {
                    this.recorder.viewer.Stop();
                }
                if (SysTray.isSupported()) {
                    this.dispose();
                } else {
                    main.exit();
                }
            }
        } else {
            super.processWindowEvent(evt);
        }
    }
}

