/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop.viewer;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JLabel;
import jrdesktop.utilities.ImageUtility;
import jrdesktop.viewer.Recorder;

public class ScreenPlayer
extends JLabel {
    private Recorder recorder;
    private Image img;
    private Rectangle screenRect = new Rectangle(0, 0, 0, 0);
    private Rectangle oldScreenRect = new Rectangle(-1, -1, -1, -1);
    private KeyAdapter keyAdapter;
    private MouseAdapter mouseAdapter;
    private MouseWheelListener mouseWheelListener;
    private MouseMotionAdapter mouseMotionAdapter;

    public ScreenPlayer(Recorder recorder) {
        this.recorder = recorder;
        this.keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                ((ScreenPlayer)ScreenPlayer.this).recorder.viewer.AddObject(e);
            }

            public void keyReleased(KeyEvent e) {
                ((ScreenPlayer)ScreenPlayer.this).recorder.viewer.AddObject(e);
            }
        };
        this.mouseWheelListener = new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                ((ScreenPlayer)ScreenPlayer.this).recorder.viewer.AddObject(e);
            }
        };
        this.mouseMotionAdapter = new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                ((ScreenPlayer)ScreenPlayer.this).recorder.viewer.AddObject(e);
            }

            public void mouseDragged(MouseEvent e) {
                ((ScreenPlayer)ScreenPlayer.this).recorder.viewer.AddObject(e);
            }
        };
        this.mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                ((ScreenPlayer)ScreenPlayer.this).recorder.viewer.AddObject(e);
            }

            public void mouseReleased(MouseEvent e) {
                ((ScreenPlayer)ScreenPlayer.this).recorder.viewer.AddObject(e);
            }
        };
        this.setFocusable(true);
    }

    public void addAdapters() {
        this.addKeyListener(this.keyAdapter);
        this.addMouseWheelListener(this.mouseWheelListener);
        this.addMouseMotionListener(this.mouseMotionAdapter);
        this.addMouseListener(this.mouseAdapter);
    }

    public void removeAdapters() {
        this.removeKeyListener(this.keyAdapter);
        this.removeMouseWheelListener(this.mouseWheelListener);
        this.removeMouseMotionListener(this.mouseMotionAdapter);
        this.removeMouseListener(this.mouseAdapter);
    }

    public void paint(Graphics g) {
        g.drawImage(this.img, 0, 0, this.screenRect.width, this.screenRect.height, this);
    }

    public void setScteenRect(Rectangle rect) {
        this.screenRect = rect;
    }

    public void UpdateScreen(byte[] data) {
        if (!this.screenRect.equals(this.oldScreenRect)) {
            this.oldScreenRect = this.screenRect;
            this.setSize(this.screenRect.getSize());
            this.setPreferredSize(this.screenRect.getSize());
        }
        this.img = ImageUtility.read(data);
        this.repaint();
    }

    public void clearScreen() {
        this.setSize(new Dimension(1, 1));
        this.setPreferredSize(new Dimension(1, 1));
        this.img = this.createImage(this.getWidth(), this.getHeight());
        this.repaint();
        this.oldScreenRect = new Rectangle(-1, -1, -1, -1);
    }

    public boolean isScreenRectChanged() {
        boolean bool = !this.screenRect.equals(this.oldScreenRect);
        this.oldScreenRect = this.screenRect;
        return bool;
    }
}

