/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop.viewer;

import java.awt.Rectangle;
import java.util.ArrayList;
import jrdesktop.viewer.ScreenPlayer;
import jrdesktop.viewer.ViewerGUI;
import jrdesktop.viewer.rmi.Viewer;

public class Recorder
extends Thread {
    private boolean recording = false;
    public Viewer viewer;
    public ViewerGUI viewerGUI;
    public ScreenPlayer screenPlayer;

    public Recorder(Viewer viewer) {
        this.viewer = viewer;
        this.start();
        this.screenPlayer = new ScreenPlayer(this);
        this.viewerGUI = new ViewerGUI(this);
    }

    public void run() {
        block0: while (true) {
            this.Wait();
            while (true) {
                if (!this.recording) continue block0;
                this.viewer.sendData();
                this.viewer.recieveData();
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Wait() {
        try {
            Recorder recorder = this;
            synchronized (recorder) {
                this.wait();
            }
        }
        catch (Exception e) {
            e.getStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Notify() {
        try {
            Recorder recorder = this;
            synchronized (recorder) {
                this.notify();
            }
        }
        catch (Exception e) {
            e.getStackTrace();
        }
    }

    public void Stop() {
        this.recording = false;
        this.screenPlayer.removeAdapters();
        this.screenPlayer.clearScreen();
        this.viewer.disconnect();
    }

    public void Start() {
        if (!this.viewer.isConnected() && this.viewer.connect() == -1) {
            return;
        }
        this.screenPlayer.addAdapters();
        this.recording = true;
        this.Notify();
    }

    public boolean isRecording() {
        return this.recording;
    }

    public void updateData(ArrayList objects) {
        this.screenPlayer.UpdateScreen((byte[])objects.get(0));
        this.screenPlayer.setScteenRect((Rectangle)objects.get(1));
    }
}

