/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import jrdesktop.AboutGUI;
import jrdesktop.Config;
import jrdesktop.SysTray;
import jrdesktop.main;
import jrdesktop.server.ActiveConnectionsGUI;
import jrdesktop.server.ConfigGUI;
import jrdesktop.server.rmi.Server;
import jrdesktop.viewer.ConnectionDialog;

public class mainFrame
extends JFrame {
    private static mainFrame frame = new mainFrame();
    private JButton jButton1;
    private JButton jButtonAbout;
    private JButton jButtonConfig;
    private JButton jButtonExit;
    private JButton jButtonStartStop;
    private JButton jButtonViewers;
    private JCheckBox jCheckBoxTrayicon;
    private JCheckBox jCheckBoxWindow;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTextArea jTextAreaStatus;

    public mainFrame() {
        this.initComponents();
        this.updateStatus();
        Config.loadConfiguration();
        this.jCheckBoxWindow.setSelected(Config.GUI_disabled);
        this.jCheckBoxTrayicon.setSelected(Config.Systray_disabled);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jButtonStartStop = new JButton();
        this.jButtonViewers = new JButton();
        this.jButtonConfig = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaStatus = new JTextArea();
        this.jCheckBoxWindow = new JCheckBox();
        this.jCheckBoxTrayicon = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jButton1 = new JButton();
        this.jButtonAbout = new JButton();
        this.jButtonExit = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("Java Remote Desktop Basic Edition");
        this.setIconImage(new ImageIcon(main.IDLE_ICON).getImage());
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent evt) {
                mainFrame.this.formWindowActivated(evt);
            }

            public void windowClosing(WindowEvent evt) {
                mainFrame.this.formWindowClosing(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Server"));
        this.jButtonStartStop.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/player_play.png")));
        this.jButtonStartStop.setText("Start");
        this.jButtonStartStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                mainFrame.this.jButtonStartStopActionPerformed(evt);
            }
        });
        this.jButtonViewers.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/connect_established.png")));
        this.jButtonViewers.setText("Active connections...");
        this.jButtonViewers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                mainFrame.this.jButtonViewersActionPerformed(evt);
            }
        });
        this.jButtonConfig.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/configure.png")));
        this.jButtonConfig.setText("Configuration");
        this.jButtonConfig.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                mainFrame.this.jButtonConfigActionPerformed(evt);
            }
        });
        this.jTextAreaStatus.setColumns(20);
        this.jTextAreaStatus.setEditable(false);
        this.jTextAreaStatus.setFont(new Font("Courier New", 0, 12));
        this.jTextAreaStatus.setRows(4);
        this.jTextAreaStatus.setBorder(BorderFactory.createTitledBorder("Status"));
        this.jScrollPane1.setViewportView(this.jTextAreaStatus);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 213, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonViewers, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonConfig, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonStartStop, -1, 159, Short.MAX_VALUE)).addContainerGap(20, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonStartStop).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonConfig).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonViewers)).addComponent(this.jScrollPane1, -2, -1, -2));
        this.jCheckBoxWindow.setSelected(true);
        this.jCheckBoxWindow.setText("Do not display this window on application startup.");
        this.jCheckBoxWindow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                mainFrame.this.jCheckBoxWindowActionPerformed(evt);
            }
        });
        this.jCheckBoxTrayicon.setSelected(true);
        this.jCheckBoxTrayicon.setText("Disable Trayicon.");
        this.jCheckBoxTrayicon.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                mainFrame.this.jCheckBoxTrayiconActionPerformed(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(""));
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/connect_creating.png")));
        this.jButton1.setText("Connect to Server ...");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                mainFrame.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButtonAbout.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/about.png")));
        this.jButtonAbout.setText("About");
        this.jButtonAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                mainFrame.this.jButtonAboutActionPerformed(evt);
            }
        });
        this.jButtonExit.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/exit.png")));
        this.jButtonExit.setText("Exit");
        this.jButtonExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                mainFrame.this.jButtonExitActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jButton1, -2, 171, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAbout, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonExit, -2, 105, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1, -2, 24, -2).addComponent(this.jButtonExit).addComponent(this.jButtonAbout)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jCheckBoxWindow).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxTrayicon)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE))).addGap(108, 108, 108)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxWindow).addComponent(this.jCheckBoxTrayicon)).addContainerGap(-1, Short.MAX_VALUE)));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 456) / 2, (screenSize.height - 251) / 2, 456, 251);
    }

    private void jButtonStartStopActionPerformed(ActionEvent evt) {
        if (Server.isRunning()) {
            Server.Stop();
        } else {
            Server.Start();
        }
        this.updateStatus();
    }

    private void jButtonViewersActionPerformed(ActionEvent evt) {
        if (mainFrame.isServerRunning()) {
            ActiveConnectionsGUI.main(null);
        }
    }

    private void jButtonConfigActionPerformed(ActionEvent evt) {
        ConfigGUI.main(null);
    }

    private void jButtonAboutActionPerformed(ActionEvent evt) {
        AboutGUI.main(null);
    }

    private void jButtonExitActionPerformed(ActionEvent evt) {
        if (JOptionPane.showConfirmDialog(this, "Exit application ?", "Confirm Dialog", 2) == 0) {
            main.exit();
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        ConnectionDialog.main(null);
    }

    private void formWindowClosing(WindowEvent evt) {
        if (evt.getID() == 201) {
            if (!(Server.isRunning() || SysTray.isEnabled() && SysTray.isSupported())) {
                if (JOptionPane.showConfirmDialog(this, "Exit application ?", "Confirm Dialog", 2) == 0) {
                    main.exit();
                }
            } else {
                this.dispose();
            }
        } else {
            super.processWindowEvent(evt);
        }
    }

    private void jCheckBoxTrayiconActionPerformed(ActionEvent evt) {
        Config.Systray_disabled = this.jCheckBoxTrayicon.isSelected();
        Config.storeConfiguration();
        if (!SysTray.isSupported()) {
            JOptionPane.showMessageDialog(this, "Systray not supported !!", "Info", 0);
            return;
        }
        if (Config.Systray_disabled) {
            if (SysTray.isEnabled()) {
                SysTray.Hide();
            }
        } else if (!SysTray.isEnabled()) {
            SysTray.Show();
        }
    }

    private void jCheckBoxWindowActionPerformed(ActionEvent evt) {
        Config.GUI_disabled = this.jCheckBoxWindow.isSelected();
        Config.storeConfiguration();
    }

    private void formWindowActivated(WindowEvent evt) {
        this.updateStatus();
    }

    public static void main(String[] args) {
        if (frame.isDisplayable()) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                frame.setVisible(true);
            }
        });
    }

    public static boolean isServerRunning() {
        boolean bool = Server.isRunning();
        if (!bool) {
            JOptionPane.showMessageDialog(null, "Server is not running !!", "Information", 1);
        }
        return bool;
    }

    public void updateStatus() {
        if (Server.isRunning()) {
            this.jTextAreaStatus.setText(Server.getStatus());
            this.jButtonStartStop.setText("Stop");
            this.jButtonStartStop.setIcon(new ImageIcon(main.STOP_ICON));
        } else {
            if (Server.isIdle()) {
                this.jTextAreaStatus.setText("Idle.");
            } else {
                this.jTextAreaStatus.setText("Stopped.");
            }
            this.jButtonStartStop.setText("Start");
            this.jButtonStartStop.setIcon(new ImageIcon(main.START_ICON));
        }
    }
}

