/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.helper.cache;

import com.ebay.sdk.ApiContext;
import com.ebay.sdk.call.GeteBayDetailsCall;
import com.ebay.sdk.helper.cache.BaseDownloader;
import com.ebay.soap.eBLBaseComponents.DetailNameCodeType;
import com.ebay.soap.eBLBaseComponents.GeteBayDetailsResponseType;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DetailsDownloader
extends BaseDownloader {
    public DetailsDownloader(ApiContext apiContext) {
        super(apiContext);
        this.FILE_EXTENSION = "eds";
        this.FILE_PREFIX = "EBayDetails";
    }

    @Override
    protected String getLastUpdateTime() throws Exception {
        GeteBayDetailsCall api = new GeteBayDetailsCall(this.apiContext);
        api.setOutputSelector(new String[]{"UpdateTime"});
        api.setDetailName(this.getDetailNames());
        api.geteBayDetails();
        GeteBayDetailsResponseType resp = api.getReturnedeBayDetails();
        Date date = resp.getUpdateTime().getTime();
        SimpleDateFormat df = new SimpleDateFormat("yyyy_MM_dd_hh_mm_ss");
        String timeStr = df.format(date);
        return timeStr;
    }

    private DetailNameCodeType[] getDetailNames() {
        DetailNameCodeType[] detailNames = new DetailNameCodeType[]{DetailNameCodeType.SHIPPING_SERVICE_DETAILS, DetailNameCodeType.SHIPPING_LOCATION_DETAILS, DetailNameCodeType.RETURN_POLICY_DETAILS};
        return detailNames;
    }

    @Override
    protected Object individualCall() throws Exception {
        GeteBayDetailsCall api = new GeteBayDetailsCall(this.apiContext);
        api.setDetailName(this.getDetailNames());
        api.geteBayDetails();
        return api.getResponseObject();
    }

    public GeteBayDetailsResponseType geteBayDetails() throws Exception {
        Object obj = this.getObject();
        GeteBayDetailsResponseType resp = (GeteBayDetailsResponseType)obj;
        return resp;
    }
}

