/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.handler;

import com.ebay.sdk.handler.BaseHandler;
import com.ebay.sdk.logging.MetricsLogger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.LogicalMessageContext;

public class MetricsLogHandler
extends BaseHandler<LogicalMessageContext>
implements LogicalHandler<LogicalMessageContext> {
    public boolean handleMessage(LogicalMessageContext logicalMessageContext) {
        if (!MetricsLogger.metricsLoggingEnabled()) {
            return true;
        }
        Boolean bl = (Boolean)logicalMessageContext.get((Object)"javax.xml.ws.handler.message.outbound");
        if (bl.booleanValue()) {
            MetricsLogger.startSdkJAXBCallInvoke();
            HashMap<String, List<String>> hashMap = (HashMap<String, List<String>>)logicalMessageContext.get((Object)"javax.xml.ws.http.request.headers");
            if (hashMap == null) {
                hashMap = new HashMap<String, List<String>>();
            }
            hashMap.put("X-EBAY-API-METRICS", Collections.singletonList("true"));
            logicalMessageContext.put((Object)"javax.xml.ws.http.request.headers", hashMap);
        } else {
            Object v;
            MetricsLogger.endSdkJAXBCallInvoke();
            Map map = (Map)logicalMessageContext.get((Object)"javax.xml.ws.http.response.headers");
            if (map != null && (v = map.get("X-EBAY-API-PROCESS-TIME")) != null) {
                String string = v.toString();
                string = this.removeChars(string, '[', ']');
                long l = this.convertProcessingTime(string);
                MetricsLogger.recordServerProcessingTime(l);
            }
        }
        return true;
    }

    public String removeChars(String string, char c, char c2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == c || string.charAt(i) == c2) continue;
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    private long convertProcessingTime(String string) {
        if (string == null) {
            return 0L;
        }
        long l = 0L;
        try {
            l = (long)Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return l;
    }
}

