/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.call;

import com.ebay.sdk.ApiCall;
import com.ebay.sdk.ApiContext;
import com.ebay.sdk.ApiException;
import com.ebay.sdk.SdkException;
import com.ebay.sdk.TimeFilter;
import com.ebay.soap.eBLBaseComponents.AbstractRequestType;
import com.ebay.soap.eBLBaseComponents.GetSellerTransactionsRequestType;
import com.ebay.soap.eBLBaseComponents.GetSellerTransactionsResponseType;
import com.ebay.soap.eBLBaseComponents.InventoryTrackingMethodCodeType;
import com.ebay.soap.eBLBaseComponents.PaginationResultType;
import com.ebay.soap.eBLBaseComponents.PaginationType;
import com.ebay.soap.eBLBaseComponents.SKUArrayType;
import com.ebay.soap.eBLBaseComponents.TransactionArrayType;
import com.ebay.soap.eBLBaseComponents.TransactionPlatformCodeType;
import com.ebay.soap.eBLBaseComponents.TransactionType;
import com.ebay.soap.eBLBaseComponents.UserType;
import java.util.ArrayList;

public class GetSellerTransactionsCall
extends ApiCall {
    private TimeFilter modifiedTimeFilter = null;
    private PaginationType pagination = null;
    private Boolean includeFinalValueFee = null;
    private Boolean includeContainingOrder = null;
    private SKUArrayType sKUArray = null;
    private TransactionPlatformCodeType platform = null;
    private Integer numberOfDays = null;
    private InventoryTrackingMethodCodeType inventoryTrackingMethod = null;
    private Boolean includeCodiceFiscale = null;
    private PaginationResultType paginationResult = null;
    private boolean hasMoreTransactions = false;
    private Integer returnedTransactionsPerPage = null;
    private Integer returnedPageNumber = null;
    private int returnedTransactionCountActual = 0;
    private UserType seller = null;
    private TransactionType[] returnedTransactions = null;
    private boolean payPalPreferred = false;

    public GetSellerTransactionsCall() {
    }

    public GetSellerTransactionsCall(ApiContext apiContext) {
        super(apiContext);
    }

    public TransactionType[] getSellerTransactions() throws ApiException, SdkException, Exception {
        GetSellerTransactionsRequestType req = new GetSellerTransactionsRequestType();
        if (this.modifiedTimeFilter == null) {
            throw new SdkException("ModifiedTimeFilter property is not set.");
        }
        req.setDetailLevel(this.getDetailLevel());
        if (this.modifiedTimeFilter != null) {
            req.setModTimeFrom(this.modifiedTimeFilter.getTimeFrom());
            req.setModTimeTo(this.modifiedTimeFilter.getTimeTo());
        }
        if (this.pagination != null) {
            req.setPagination(this.pagination);
        }
        if (this.includeFinalValueFee != null) {
            req.setIncludeFinalValueFee(this.includeFinalValueFee);
        }
        if (this.includeContainingOrder != null) {
            req.setIncludeContainingOrder(this.includeContainingOrder);
        }
        if (this.sKUArray != null) {
            req.setSKUArray(this.sKUArray);
        }
        if (this.platform != null) {
            req.setPlatform(this.platform);
        }
        if (this.inventoryTrackingMethod != null) {
            req.setInventoryTrackingMethod(this.inventoryTrackingMethod);
        }
        if (this.includeCodiceFiscale != null) {
            req.setIncludeCodiceFiscale(this.includeCodiceFiscale);
        }
        GetSellerTransactionsResponseType resp = (GetSellerTransactionsResponseType)this.execute((AbstractRequestType)req);
        this.paginationResult = resp.getPaginationResult();
        this.hasMoreTransactions = resp.isHasMoreTransactions() == null ? false : resp.isHasMoreTransactions();
        this.returnedTransactionsPerPage = resp.getTransactionsPerPage();
        this.returnedPageNumber = resp.getPageNumber();
        this.returnedTransactionCountActual = resp.getReturnedTransactionCountActual() == null ? 0 : resp.getReturnedTransactionCountActual();
        this.seller = resp.getSeller();
        this.returnedTransactions = resp.getTransactionArray() == null ? null : resp.getTransactionArray().getTransaction();
        this.payPalPreferred = resp.isPayPalPreferred() == null ? false : resp.isPayPalPreferred();
        return this.getReturnedTransactions();
    }

    public Boolean getIncludeCodiceFiscale() {
        return this.includeCodiceFiscale;
    }

    public void setIncludeCodiceFiscale(Boolean includeCodiceFiscale) {
        this.includeCodiceFiscale = includeCodiceFiscale;
    }

    public Boolean getIncludeContainingOrder() {
        return this.includeContainingOrder;
    }

    public void setIncludeContainingOrder(Boolean includeContainingOrder) {
        this.includeContainingOrder = includeContainingOrder;
    }

    public Boolean getIncludeFinalValueFee() {
        return this.includeFinalValueFee;
    }

    public void setIncludeFinalValueFee(Boolean includeFinalValueFee) {
        this.includeFinalValueFee = includeFinalValueFee;
    }

    public InventoryTrackingMethodCodeType getInventoryTrackingMethod() {
        return this.inventoryTrackingMethod;
    }

    public void setInventoryTrackingMethod(InventoryTrackingMethodCodeType inventoryTrackingMethod) {
        this.inventoryTrackingMethod = inventoryTrackingMethod;
    }

    public TimeFilter getModifiedTimeFilter() {
        return this.modifiedTimeFilter;
    }

    public void setModifiedTimeFilter(TimeFilter modifiedTimeFilter) {
        this.modifiedTimeFilter = modifiedTimeFilter;
    }

    public Integer getNumberOfDays() {
        return this.numberOfDays;
    }

    public void setNumberOfDays(Integer numberOfDays) {
        this.numberOfDays = numberOfDays;
    }

    public PaginationType getPagination() {
        return this.pagination;
    }

    public void setPagination(PaginationType pagination) {
        this.pagination = pagination;
    }

    public TransactionPlatformCodeType getPlatform() {
        return this.platform;
    }

    public void setPlatform(TransactionPlatformCodeType platform) {
        this.platform = platform;
    }

    public SKUArrayType getSKUArray() {
        return this.sKUArray;
    }

    public void setSKUArray(SKUArrayType sKUArray) {
        this.sKUArray = sKUArray;
    }

    public TransactionType[] getEntireSellerTransactions() throws ApiException, SdkException, Exception {
        if (this.modifiedTimeFilter == null) {
            throw new SdkException("TimeFilter is not set.");
        }
        return this.getEntireSellerTransactions(this.modifiedTimeFilter);
    }

    public TransactionType[] getEntireSellerTransactions(TimeFilter modifiedTimeFilter) throws ApiException, SdkException, Exception {
        GetSellerTransactionsRequestType req = new GetSellerTransactionsRequestType();
        req.setModTimeFrom(modifiedTimeFilter.getTimeFrom());
        req.setModTimeTo(modifiedTimeFilter.getTimeTo());
        int pageNum = 1;
        PaginationType pgn = new PaginationType();
        pgn.setEntriesPerPage(new Integer(100));
        pgn.setPageNumber(new Integer(pageNum++));
        req.setPagination(pgn);
        if (this.includeFinalValueFee != null) {
            req.setIncludeFinalValueFee(this.includeFinalValueFee);
        }
        if (this.includeContainingOrder != null) {
            req.setIncludeContainingOrder(this.includeContainingOrder);
        }
        if (this.sKUArray != null) {
            req.setSKUArray(this.sKUArray);
        }
        if (this.platform != null) {
            req.setPlatform(this.platform);
        }
        if (this.inventoryTrackingMethod != null) {
            req.setInventoryTrackingMethod(this.inventoryTrackingMethod);
        }
        if (this.includeCodiceFiscale != null) {
            req.setIncludeCodiceFiscale(this.includeCodiceFiscale);
        }
        ArrayList<TransactionType> transList = new ArrayList<TransactionType>();
        while (true) {
            GetSellerTransactionsResponseType resp;
            TransactionArrayType tarray;
            TransactionType[] tm;
            TransactionType[] transactionTypeArray = tm = (tarray = (resp = (GetSellerTransactionsResponseType)this.execute((AbstractRequestType)req)).getTransactionArray()) == null ? null : tarray.getTransaction();
            if (tm != null) {
                for (int i = 0; i < tm.length; ++i) {
                    transList.add(tm[i]);
                }
            }
            if (resp.getReturnedTransactionCountActual() != null) {
                this.returnedTransactionCountActual = resp.getReturnedTransactionCountActual();
            }
            if (!resp.isHasMoreTransactions().booleanValue()) break;
            pgn.setPageNumber(new Integer(pageNum++));
        }
        this.returnedTransactions = new TransactionType[transList.size()];
        for (int i = 0; i < this.returnedTransactions.length; ++i) {
            this.returnedTransactions[i] = (TransactionType)transList.get(i);
        }
        return this.returnedTransactions;
    }

    public TransactionType[] getSellerTransactions(TimeFilter modifiedTimeFilter) throws ApiException, SdkException, Exception {
        this.modifiedTimeFilter = modifiedTimeFilter;
        return this.getSellerTransactions();
    }

    public TimeFilter getTimeFilter() {
        return this.modifiedTimeFilter;
    }

    public void setTimeFilter(TimeFilter timeFilter) {
        this.modifiedTimeFilter = timeFilter;
    }

    public boolean getHasMoreTransactions() {
        return this.hasMoreTransactions;
    }

    public PaginationResultType getPaginationResult() {
        return this.paginationResult;
    }

    public boolean getPayPalPreferred() {
        return this.payPalPreferred;
    }

    public Integer getReturnedPageNumber() {
        return this.returnedPageNumber;
    }

    public int getReturnedTransactionCountActual() {
        return this.returnedTransactionCountActual;
    }

    public TransactionType[] getReturnedTransactions() {
        return this.returnedTransactions;
    }

    public Integer getReturnedTransactionsPerPage() {
        return this.returnedTransactionsPerPage;
    }

    public UserType getSeller() {
        return this.seller;
    }
}

