/*
 * Decompiled with CFR 0.152.
 */
package de.jgsoftwares.dnsserver.config;

import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configurers.provisioning.JdbcUserDetailsManagerConfigurer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;

@Configuration
@EnableWebSecurity
public class SpringSecurityConfiguration
extends WebSecurityConfigurerAdapter {
    @Autowired
    BCryptPasswordEncoder passwordEncoder;
    @Autowired
    private DataSource dataSource;

    @Autowired
    public void configAuthentication(AuthenticationManagerBuilder authBuilder) throws Exception {
        ((JdbcUserDetailsManagerConfigurer)authBuilder.jdbcAuthentication().dataSource(this.dataSource).passwordEncoder((PasswordEncoder)new BCryptPasswordEncoder())).authoritiesByUsernameQuery("select username, role from users where username=?").usersByUsernameQuery("select username, password, enabled from users where username=?");
    }

    @Bean
    public BCryptPasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)http.csrf().disable()).cors().and()).authorizeRequests().antMatchers(new String[]{"/**", "/h2-console/**", "static/**"})).permitAll().antMatchers(new String[]{"index"})).access("hasAuthority('ROLE_ADMIN','ROLE_USER')").anyRequest()).authenticated().and()).formLogin();
    }

    public void configure(WebSecurity web) {
        web.ignoring().antMatchers(new String[]{"/h2-console/**"});
    }
}

