/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.spi;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import org.xbill.DNS.AAAARecord;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Name;
import org.xbill.DNS.PTRRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.ReverseMap;
import org.xbill.DNS.TextParseException;

public class DNSJavaNameService
implements InvocationHandler {
    private static final String nsProperty = "sun.net.spi.nameservice.nameservers";
    private static final String domainProperty = "sun.net.spi.nameservice.domain";
    private static final String v6Property = "java.net.preferIPv6Addresses";
    private boolean preferV6 = false;

    protected DNSJavaNameService() {
        String string = System.getProperty(nsProperty);
        String string2 = System.getProperty(domainProperty);
        String string3 = System.getProperty(v6Property);
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            String[] stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n++] = stringTokenizer.nextToken();
            }
            try {
                ExtendedResolver extendedResolver = new ExtendedResolver(stringArray);
                Lookup.setDefaultResolver((Resolver)extendedResolver);
            }
            catch (UnknownHostException unknownHostException) {
                System.err.println("DNSJavaNameService: invalid sun.net.spi.nameservice.nameservers");
            }
        }
        if (string2 != null) {
            try {
                Lookup.setDefaultSearchPath((String[])new String[]{string2});
            }
            catch (TextParseException textParseException) {
                System.err.println("DNSJavaNameService: invalid sun.net.spi.nameservice.domain");
            }
        }
        if (string3 != null && string3.equalsIgnoreCase("true")) {
            this.preferV6 = true;
        }
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        try {
            if (method.getName().equals("getHostByAddr")) {
                return this.getHostByAddr((byte[])objectArray[0]);
            }
            if (method.getName().equals("lookupAllHostAddr")) {
                InetAddress[] inetAddressArray = this.lookupAllHostAddr((String)objectArray[0]);
                Class<?> clazz = method.getReturnType();
                if (clazz.equals(InetAddress[].class)) {
                    return inetAddressArray;
                }
                if (clazz.equals(byte[][].class)) {
                    int n = inetAddressArray.length;
                    byte[][] byArrayArray = new byte[n][];
                    for (int i = 0; i < n; ++i) {
                        byte[] byArray = inetAddressArray[i].getAddress();
                        byArrayArray[i] = byArray;
                    }
                    return byArrayArray;
                }
            }
        }
        catch (Throwable throwable) {
            System.err.println("DNSJavaNameService: Unexpected error.");
            throwable.printStackTrace();
            throw throwable;
        }
        throw new IllegalArgumentException("Unknown function name or arguments.");
    }

    public InetAddress[] lookupAllHostAddr(String string) throws UnknownHostException {
        Name name = null;
        try {
            name = new Name(string);
        }
        catch (TextParseException textParseException) {
            throw new UnknownHostException(string);
        }
        Record[] recordArray = null;
        if (this.preferV6) {
            recordArray = new Lookup(name, 28).run();
        }
        if (recordArray == null) {
            recordArray = new Lookup(name, 1).run();
        }
        if (recordArray == null && !this.preferV6) {
            recordArray = new Lookup(name, 28).run();
        }
        if (recordArray == null) {
            throw new UnknownHostException(string);
        }
        InetAddress[] inetAddressArray = new InetAddress[recordArray.length];
        for (int i = 0; i < recordArray.length; ++i) {
            ARecord aRecord;
            Record record = recordArray[i];
            if (recordArray[i] instanceof ARecord) {
                aRecord = (ARecord)recordArray[i];
                inetAddressArray[i] = aRecord.getAddress();
                continue;
            }
            aRecord = (AAAARecord)recordArray[i];
            inetAddressArray[i] = aRecord.getAddress();
        }
        return inetAddressArray;
    }

    public String getHostByAddr(byte[] byArray) throws UnknownHostException {
        Name name = ReverseMap.fromAddress((InetAddress)InetAddress.getByAddress(byArray));
        Record[] recordArray = new Lookup(name, 12).run();
        if (recordArray == null) {
            throw new UnknownHostException();
        }
        return ((PTRRecord)recordArray[0]).getTarget().toString();
    }
}

