/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import org.xbill.DNS.Address;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.WKSRecord;

/*
 * Exception performing whole class analysis ignored.
 */
public class WKSRecord
extends Record {
    private static final long serialVersionUID = -9104259763909119805L;
    private byte[] address;
    private int protocol;
    private int[] services;

    WKSRecord() {
    }

    Record getObject() {
        return new WKSRecord();
    }

    public WKSRecord(Name name, int n, long l, InetAddress inetAddress, int n2, int[] nArray) {
        super(name, 11, n, l);
        if (Address.familyOf((InetAddress)inetAddress) != 1) {
            throw new IllegalArgumentException("invalid IPv4 address");
        }
        this.address = inetAddress.getAddress();
        this.protocol = WKSRecord.checkU8((String)"protocol", (int)n2);
        for (int i = 0; i < nArray.length; ++i) {
            WKSRecord.checkU16((String)"service", (int)nArray[i]);
        }
        this.services = new int[nArray.length];
        System.arraycopy(nArray, 0, this.services, 0, nArray.length);
        Arrays.sort(this.services);
    }

    void rrFromWire(DNSInput dNSInput) throws IOException {
        int n;
        this.address = dNSInput.readByteArray(4);
        this.protocol = dNSInput.readU8();
        byte[] byArray = dNSInput.readByteArray();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n = 0; n < byArray.length; ++n) {
            for (int i = 0; i < 8; ++i) {
                int n2 = byArray[n] & 0xFF;
                if ((n2 & 1 << 7 - i) == 0) continue;
                arrayList.add(new Integer(n * 8 + i));
            }
        }
        this.services = new int[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            this.services[n] = (Integer)arrayList.get(n);
        }
    }

    void rdataFromString(Tokenizer tokenizer, Name name) throws IOException {
        Tokenizer.Token token;
        String string = tokenizer.getString();
        this.address = Address.toByteArray((String)string, (int)1);
        if (this.address == null) {
            throw tokenizer.exception("invalid address");
        }
        string = tokenizer.getString();
        this.protocol = Protocol.value((String)string);
        if (this.protocol < 0) {
            throw tokenizer.exception("Invalid IP protocol: " + string);
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while ((token = tokenizer.get()).isString()) {
            int n = Service.value((String)token.value);
            if (n < 0) {
                throw tokenizer.exception("Invalid TCP/UDP service: " + token.value);
            }
            arrayList.add(new Integer(n));
        }
        tokenizer.unget();
        this.services = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            this.services[i] = (Integer)arrayList.get(i);
        }
    }

    String rrToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Address.toDottedQuad((byte[])this.address));
        stringBuffer.append(" ");
        stringBuffer.append(this.protocol);
        for (int i = 0; i < this.services.length; ++i) {
            stringBuffer.append(" " + this.services[i]);
        }
        return stringBuffer.toString();
    }

    public InetAddress getAddress() {
        try {
            return InetAddress.getByAddress(this.address);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public int getProtocol() {
        return this.protocol;
    }

    public int[] getServices() {
        return this.services;
    }

    void rrToWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        dNSOutput.writeByteArray(this.address);
        dNSOutput.writeU8(this.protocol);
        int n = this.services[this.services.length - 1];
        byte[] byArray = new byte[n / 8 + 1];
        for (int i = 0; i < this.services.length; ++i) {
            int n2 = this.services[i];
            int n3 = n2 / 8;
            byArray[n3] = (byte)(byArray[n3] | 1 << 7 - n2 % 8);
        }
        dNSOutput.writeByteArray(byArray);
    }
}

