/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.Iterator;
import org.xbill.DNS.DClass;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.RelativeNameException;
import org.xbill.DNS.Tokenizer;

public class Update
extends Message {
    private Name origin;
    private int dclass;

    public Update(Name name, int n) {
        if (!name.isAbsolute()) {
            throw new RelativeNameException(name);
        }
        DClass.check((int)n);
        this.getHeader().setOpcode(5);
        Record record = Record.newRecord((Name)name, (int)6, (int)1);
        this.addRecord(record, 0);
        this.origin = name;
        this.dclass = n;
    }

    public Update(Name name) {
        this(name, 1);
    }

    private void newPrereq(Record record) {
        this.addRecord(record, 1);
    }

    private void newUpdate(Record record) {
        this.addRecord(record, 2);
    }

    public void present(Name name) {
        this.newPrereq(Record.newRecord((Name)name, (int)255, (int)255, (long)0L));
    }

    public void present(Name name, int n) {
        this.newPrereq(Record.newRecord((Name)name, (int)n, (int)255, (long)0L));
    }

    public void present(Name name, int n, String string) throws IOException {
        this.newPrereq(Record.fromString((Name)name, (int)n, (int)this.dclass, (long)0L, (String)string, (Name)this.origin));
    }

    public void present(Name name, int n, Tokenizer tokenizer) throws IOException {
        this.newPrereq(Record.fromString((Name)name, (int)n, (int)this.dclass, (long)0L, (Tokenizer)tokenizer, (Name)this.origin));
    }

    public void present(Record record) {
        this.newPrereq(record);
    }

    public void absent(Name name) {
        this.newPrereq(Record.newRecord((Name)name, (int)255, (int)254, (long)0L));
    }

    public void absent(Name name, int n) {
        this.newPrereq(Record.newRecord((Name)name, (int)n, (int)254, (long)0L));
    }

    public void add(Name name, int n, long l, String string) throws IOException {
        this.newUpdate(Record.fromString((Name)name, (int)n, (int)this.dclass, (long)l, (String)string, (Name)this.origin));
    }

    public void add(Name name, int n, long l, Tokenizer tokenizer) throws IOException {
        this.newUpdate(Record.fromString((Name)name, (int)n, (int)this.dclass, (long)l, (Tokenizer)tokenizer, (Name)this.origin));
    }

    public void add(Record record) {
        this.newUpdate(record);
    }

    public void add(Record[] recordArray) {
        for (int i = 0; i < recordArray.length; ++i) {
            this.add(recordArray[i]);
        }
    }

    public void add(RRset rRset) {
        Iterator iterator = rRset.rrs();
        while (iterator.hasNext()) {
            this.add((Record)iterator.next());
        }
    }

    public void delete(Name name) {
        this.newUpdate(Record.newRecord((Name)name, (int)255, (int)255, (long)0L));
    }

    public void delete(Name name, int n) {
        this.newUpdate(Record.newRecord((Name)name, (int)n, (int)255, (long)0L));
    }

    public void delete(Name name, int n, String string) throws IOException {
        this.newUpdate(Record.fromString((Name)name, (int)n, (int)254, (long)0L, (String)string, (Name)this.origin));
    }

    public void delete(Name name, int n, Tokenizer tokenizer) throws IOException {
        this.newUpdate(Record.fromString((Name)name, (int)n, (int)254, (long)0L, (Tokenizer)tokenizer, (Name)this.origin));
    }

    public void delete(Record record) {
        this.newUpdate(record.withDClass(254, 0L));
    }

    public void delete(Record[] recordArray) {
        for (int i = 0; i < recordArray.length; ++i) {
            this.delete(recordArray[i]);
        }
    }

    public void delete(RRset rRset) {
        Iterator iterator = rRset.rrs();
        while (iterator.hasNext()) {
            this.delete((Record)iterator.next());
        }
    }

    public void replace(Name name, int n, long l, String string) throws IOException {
        this.delete(name, n);
        this.add(name, n, l, string);
    }

    public void replace(Name name, int n, long l, Tokenizer tokenizer) throws IOException {
        this.delete(name, n);
        this.add(name, n, l, tokenizer);
    }

    public void replace(Record record) {
        this.delete(record.getName(), record.getType());
        this.add(record);
    }

    public void replace(Record[] recordArray) {
        for (int i = 0; i < recordArray.length; ++i) {
            this.replace(recordArray[i]);
        }
    }

    public void replace(RRset rRset) {
        this.delete(rRset.getName(), rRset.getType());
        Iterator iterator = rRset.rrs();
        while (iterator.hasNext()) {
            this.add((Record)iterator.next());
        }
    }
}

