/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.Record;
import org.xbill.DNS.TSIGRecord;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.utils.base64;

/*
 * Exception performing whole class analysis ignored.
 */
public class TSIG {
    public static final Name HMAC_MD5;
    public static final Name HMAC;
    public static final Name HMAC_SHA1;
    public static final Name HMAC_SHA224;
    public static final Name HMAC_SHA256;
    public static final Name HMAC_SHA384;
    public static final Name HMAC_SHA512;
    private static Map algMap;
    public static final short FUDGE = 300;
    private Name name;
    private Name alg;
    private Mac hmac;

    public static Name algorithmToName(String string) {
        for (Map.Entry entry : algMap.entrySet()) {
            if (!string.equalsIgnoreCase((String)entry.getValue())) continue;
            return (Name)entry.getKey();
        }
        throw new IllegalArgumentException("Unknown algorithm");
    }

    public static String nameToAlgorithm(Name name) {
        String string = (String)algMap.get(name);
        if (string != null) {
            return string;
        }
        throw new IllegalArgumentException("Unknown algorithm");
    }

    private static boolean verify(Mac mac, byte[] byArray) {
        return TSIG.verify((Mac)mac, (byte[])byArray, (boolean)false);
    }

    private static boolean verify(Mac mac, byte[] byArray, boolean bl) {
        byte[] byArray2 = mac.doFinal();
        if (bl && byArray.length < byArray2.length) {
            byte[] byArray3 = new byte[byArray.length];
            System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
            byArray2 = byArray3;
        }
        return Arrays.equals(byArray, byArray2);
    }

    private void init_hmac(String string, SecretKey secretKey) {
        try {
            this.hmac = Mac.getInstance(string);
            this.hmac.init(secretKey);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalArgumentException("Caught security exception setting up HMAC.");
        }
    }

    public TSIG(Name name, Name name2, byte[] byArray) {
        this.name = name2;
        this.alg = name;
        String string = TSIG.nameToAlgorithm((Name)name);
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, string);
        this.init_hmac(string, (SecretKey)secretKeySpec);
    }

    public TSIG(Name name, Name name2, SecretKey secretKey) {
        this.name = name2;
        this.alg = name;
        String string = TSIG.nameToAlgorithm((Name)name);
        this.init_hmac(string, secretKey);
    }

    public TSIG(Mac mac, Name name) {
        this.name = name;
        this.hmac = mac;
        this.alg = TSIG.algorithmToName((String)mac.getAlgorithm());
    }

    public TSIG(Name name, byte[] byArray) {
        this(HMAC_MD5, name, byArray);
    }

    public TSIG(Name name, String string, String string2) {
        byte[] byArray = base64.fromString((String)string2);
        if (byArray == null) {
            throw new IllegalArgumentException("Invalid TSIG key string");
        }
        try {
            this.name = Name.fromString((String)string, (Name)Name.root);
        }
        catch (TextParseException textParseException) {
            throw new IllegalArgumentException("Invalid TSIG key name");
        }
        this.alg = name;
        String string3 = TSIG.nameToAlgorithm((Name)this.alg);
        this.init_hmac(string3, (SecretKey)new SecretKeySpec(byArray, string3));
    }

    public TSIG(String string, String string2, String string3) {
        this(TSIG.algorithmToName((String)string), string2, string3);
    }

    public TSIG(String string, String string2) {
        this(HMAC_MD5, string, string2);
    }

    public static TSIG fromString(String string) {
        String[] stringArray = string.split("[:/]", 3);
        if (stringArray.length < 2) {
            throw new IllegalArgumentException("Invalid TSIG key specification");
        }
        if (stringArray.length == 3) {
            try {
                return new TSIG(stringArray[0], stringArray[1], stringArray[2]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                stringArray = string.split("[:/]", 2);
            }
        }
        return new TSIG(HMAC_MD5, stringArray[0], stringArray[1]);
    }

    public TSIGRecord generate(Message message, byte[] byArray, int n, TSIGRecord tSIGRecord) {
        DNSOutput dNSOutput;
        int n2;
        Date date = n != 18 ? new Date() : tSIGRecord.getTimeSigned();
        boolean bl = false;
        if (n == 0 || n == 18) {
            bl = true;
            this.hmac.reset();
        }
        if ((n2 = Options.intValue((String)"tsigfudge")) < 0 || n2 > Short.MAX_VALUE) {
            n2 = 300;
        }
        if (tSIGRecord != null) {
            dNSOutput = new DNSOutput();
            dNSOutput.writeU16(tSIGRecord.getSignature().length);
            if (bl) {
                this.hmac.update(dNSOutput.toByteArray());
                this.hmac.update(tSIGRecord.getSignature());
            }
        }
        if (bl) {
            this.hmac.update(byArray);
        }
        dNSOutput = new DNSOutput();
        this.name.toWireCanonical(dNSOutput);
        dNSOutput.writeU16(255);
        dNSOutput.writeU32(0L);
        this.alg.toWireCanonical(dNSOutput);
        long l = date.getTime() / 1000L;
        int n3 = (int)(l >> 32);
        long l2 = l & 0xFFFFFFFFL;
        dNSOutput.writeU16(n3);
        dNSOutput.writeU32(l2);
        dNSOutput.writeU16(n2);
        dNSOutput.writeU16(n);
        dNSOutput.writeU16(0);
        if (bl) {
            this.hmac.update(dNSOutput.toByteArray());
        }
        byte[] byArray2 = bl ? this.hmac.doFinal() : new byte[]{};
        byte[] byArray3 = null;
        if (n == 18) {
            dNSOutput = new DNSOutput();
            l = new Date().getTime() / 1000L;
            n3 = (int)(l >> 32);
            l2 = l & 0xFFFFFFFFL;
            dNSOutput.writeU16(n3);
            dNSOutput.writeU32(l2);
            byArray3 = dNSOutput.toByteArray();
        }
        return new TSIGRecord(this.name, 255, 0L, this.alg, date, n2, byArray2, message.getHeader().getID(), n, byArray3);
    }

    public void apply(Message message, int n, TSIGRecord tSIGRecord) {
        TSIGRecord tSIGRecord2 = this.generate(message, message.toWire(), n, tSIGRecord);
        message.addRecord((Record)tSIGRecord2, 3);
        message.tsigState = 3;
    }

    public void apply(Message message, TSIGRecord tSIGRecord) {
        this.apply(message, 0, tSIGRecord);
    }

    public void applyStream(Message message, TSIGRecord tSIGRecord, boolean bl) {
        if (bl) {
            this.apply(message, tSIGRecord);
            return;
        }
        Date date = new Date();
        this.hmac.reset();
        int n = Options.intValue((String)"tsigfudge");
        if (n < 0 || n > Short.MAX_VALUE) {
            n = 300;
        }
        DNSOutput dNSOutput = new DNSOutput();
        dNSOutput.writeU16(tSIGRecord.getSignature().length);
        this.hmac.update(dNSOutput.toByteArray());
        this.hmac.update(tSIGRecord.getSignature());
        this.hmac.update(message.toWire());
        dNSOutput = new DNSOutput();
        long l = date.getTime() / 1000L;
        int n2 = (int)(l >> 32);
        long l2 = l & 0xFFFFFFFFL;
        dNSOutput.writeU16(n2);
        dNSOutput.writeU32(l2);
        dNSOutput.writeU16(n);
        this.hmac.update(dNSOutput.toByteArray());
        byte[] byArray = this.hmac.doFinal();
        byte[] byArray2 = null;
        TSIGRecord tSIGRecord2 = new TSIGRecord(this.name, 255, 0L, this.alg, date, n, byArray, message.getHeader().getID(), 0, byArray2);
        message.addRecord((Record)tSIGRecord2, 3);
        message.tsigState = 3;
    }

    public byte verify(Message message, byte[] byArray, int n, TSIGRecord tSIGRecord) {
        Object object;
        message.tsigState = 4;
        TSIGRecord tSIGRecord2 = message.getTSIG();
        this.hmac.reset();
        if (tSIGRecord2 == null) {
            return 1;
        }
        if (!tSIGRecord2.getName().equals((Object)this.name) || !tSIGRecord2.getAlgorithm().equals((Object)this.alg)) {
            if (Options.check((String)"verbose")) {
                System.err.println("BADKEY failure");
            }
            return 17;
        }
        long l = System.currentTimeMillis();
        long l2 = tSIGRecord2.getTimeSigned().getTime();
        long l3 = tSIGRecord2.getFudge();
        if (Math.abs(l - l2) > l3 * 1000L) {
            if (Options.check((String)"verbose")) {
                System.err.println("BADTIME failure");
            }
            return 18;
        }
        if (tSIGRecord != null && tSIGRecord2.getError() != 17 && tSIGRecord2.getError() != 16) {
            object = new DNSOutput();
            object.writeU16(tSIGRecord.getSignature().length);
            this.hmac.update(object.toByteArray());
            this.hmac.update(tSIGRecord.getSignature());
        }
        message.getHeader().decCount(3);
        object = message.getHeader().toWire();
        message.getHeader().incCount(3);
        this.hmac.update((byte[])object);
        int n2 = message.tsigstart - ((byte[])object).length;
        this.hmac.update(byArray, ((byte[])object).length, n2);
        DNSOutput dNSOutput = new DNSOutput();
        tSIGRecord2.getName().toWireCanonical(dNSOutput);
        dNSOutput.writeU16(tSIGRecord2.dclass);
        dNSOutput.writeU32(tSIGRecord2.ttl);
        tSIGRecord2.getAlgorithm().toWireCanonical(dNSOutput);
        long l4 = tSIGRecord2.getTimeSigned().getTime() / 1000L;
        int n3 = (int)(l4 >> 32);
        long l5 = l4 & 0xFFFFFFFFL;
        dNSOutput.writeU16(n3);
        dNSOutput.writeU32(l5);
        dNSOutput.writeU16(tSIGRecord2.getFudge());
        dNSOutput.writeU16(tSIGRecord2.getError());
        if (tSIGRecord2.getOther() != null) {
            dNSOutput.writeU16(tSIGRecord2.getOther().length);
            dNSOutput.writeByteArray(tSIGRecord2.getOther());
        } else {
            dNSOutput.writeU16(0);
        }
        this.hmac.update(dNSOutput.toByteArray());
        byte[] byArray2 = tSIGRecord2.getSignature();
        int n4 = this.hmac.getMacLength();
        int n5 = this.hmac.getAlgorithm().toLowerCase().contains("md5") ? 10 : n4 / 2;
        if (byArray2.length > n4) {
            if (Options.check((String)"verbose")) {
                System.err.println("BADSIG: signature too long");
            }
            return 16;
        }
        if (byArray2.length < n5) {
            if (Options.check((String)"verbose")) {
                System.err.println("BADSIG: signature too short");
            }
            return 16;
        }
        if (!TSIG.verify((Mac)this.hmac, (byte[])byArray2, (boolean)true)) {
            if (Options.check((String)"verbose")) {
                System.err.println("BADSIG: signature verification");
            }
            return 16;
        }
        message.tsigState = 1;
        return 0;
    }

    public int verify(Message message, byte[] byArray, TSIGRecord tSIGRecord) {
        return this.verify(message, byArray, byArray.length, tSIGRecord);
    }

    public int recordLength() {
        return this.name.length() + 10 + this.alg.length() + 8 + 18 + 4 + 8;
    }

    static {
        HMAC = HMAC_MD5 = Name.fromConstantString((String)"HMAC-MD5.SIG-ALG.REG.INT.");
        HMAC_SHA1 = Name.fromConstantString((String)"hmac-sha1.");
        HMAC_SHA224 = Name.fromConstantString((String)"hmac-sha224.");
        HMAC_SHA256 = Name.fromConstantString((String)"hmac-sha256.");
        HMAC_SHA384 = Name.fromConstantString((String)"hmac-sha384.");
        HMAC_SHA512 = Name.fromConstantString((String)"hmac-sha512.");
        HashMap<Name, String> hashMap = new HashMap<Name, String>();
        hashMap.put(HMAC_MD5, "HmacMD5");
        hashMap.put(HMAC_SHA1, "HmacSHA1");
        hashMap.put(HMAC_SHA224, "HmacSHA224");
        hashMap.put(HMAC_SHA256, "HmacSHA256");
        hashMap.put(HMAC_SHA384, "HmacSHA384");
        hashMap.put(HMAC_SHA512, "HmacSHA512");
        algMap = Collections.unmodifiableMap(hashMap);
    }
}

