/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.xbill.DNS.DClass;
import org.xbill.DNS.Generator;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.RelativeNameException;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.TTL;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.Type;

public class Master {
    private Name origin;
    private File file;
    private Record last = null;
    private long defaultTTL;
    private Master included = null;
    private Tokenizer st;
    private int currentType;
    private int currentDClass;
    private long currentTTL;
    private boolean needSOATTL;
    private Generator generator;
    private List generators;
    private boolean noExpandGenerate;

    Master(File file, Name name, long l) throws IOException {
        if (name != null && !name.isAbsolute()) {
            throw new RelativeNameException(name);
        }
        this.file = file;
        this.st = new Tokenizer(file);
        this.origin = name;
        this.defaultTTL = l;
    }

    public Master(String string, Name name, long l) throws IOException {
        this(new File(string), name, l);
    }

    public Master(String string, Name name) throws IOException {
        this(new File(string), name, -1L);
    }

    public Master(String string) throws IOException {
        this(new File(string), null, -1L);
    }

    public Master(InputStream inputStream, Name name, long l) {
        if (name != null && !name.isAbsolute()) {
            throw new RelativeNameException(name);
        }
        this.st = new Tokenizer(inputStream);
        this.origin = name;
        this.defaultTTL = l;
    }

    public Master(InputStream inputStream, Name name) {
        this(inputStream, name, -1L);
    }

    public Master(InputStream inputStream) {
        this(inputStream, null, -1L);
    }

    private Name parseName(String string, Name name) throws TextParseException {
        try {
            return Name.fromString((String)string, (Name)name);
        }
        catch (TextParseException textParseException) {
            throw this.st.exception(textParseException.getMessage());
        }
    }

    private void parseTTLClassAndType() throws IOException {
        String string;
        boolean bl;
        block10: {
            bl = false;
            bl = false;
            string = this.st.getString();
            this.currentDClass = DClass.value((String)string);
            if (this.currentDClass >= 0) {
                string = this.st.getString();
                bl = true;
            }
            this.currentTTL = -1L;
            try {
                this.currentTTL = TTL.parseTTL((String)string);
                string = this.st.getString();
            }
            catch (NumberFormatException numberFormatException) {
                if (this.defaultTTL >= 0L) {
                    this.currentTTL = this.defaultTTL;
                }
                if (this.last == null) break block10;
                this.currentTTL = this.last.getTTL();
            }
        }
        if (!bl) {
            this.currentDClass = DClass.value((String)string);
            if (this.currentDClass >= 0) {
                string = this.st.getString();
            } else {
                this.currentDClass = 1;
            }
        }
        if ((this.currentType = Type.value((String)string)) < 0) {
            throw this.st.exception("Invalid type '" + string + "'");
        }
        if (this.currentTTL < 0L) {
            if (this.currentType != 6) {
                throw this.st.exception("missing TTL");
            }
            this.needSOATTL = true;
            this.currentTTL = 0L;
        }
    }

    private long parseUInt32(String string) {
        if (!Character.isDigit(string.charAt(0))) {
            return -1L;
        }
        try {
            long l = Long.parseLong(string);
            if (l < 0L || l > 0xFFFFFFFFL) {
                return -1L;
            }
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    private void startGenerate() throws IOException {
        String string = this.st.getIdentifier();
        int n = string.indexOf("-");
        if (n < 0) {
            throw this.st.exception("Invalid $GENERATE range specifier: " + string);
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        String string4 = null;
        n = string3.indexOf("/");
        if (n >= 0) {
            string4 = string3.substring(n + 1);
            string3 = string3.substring(0, n);
        }
        long l = this.parseUInt32(string2);
        long l2 = this.parseUInt32(string3);
        long l3 = string4 != null ? this.parseUInt32(string4) : 1L;
        if (l < 0L || l2 < 0L || l > l2 || l3 <= 0L) {
            throw this.st.exception("Invalid $GENERATE range specifier: " + string);
        }
        String string5 = this.st.getIdentifier();
        this.parseTTLClassAndType();
        if (!Generator.supportedType((int)this.currentType)) {
            throw this.st.exception("$GENERATE does not support " + Type.string((int)this.currentType) + " records");
        }
        String string6 = this.st.getIdentifier();
        this.st.getEOL();
        this.st.unget();
        this.generator = new Generator(l, l2, l3, string5, this.currentType, this.currentDClass, this.currentTTL, string6, this.origin);
        if (this.generators == null) {
            this.generators = new ArrayList(1);
        }
        this.generators.add(this.generator);
    }

    private void endGenerate() throws IOException {
        this.st.getEOL();
        this.generator = null;
    }

    private Record nextGenerated() throws IOException {
        try {
            return this.generator.nextRecord();
        }
        catch (Tokenizer.TokenizerException tokenizerException) {
            throw this.st.exception("Parsing $GENERATE: " + tokenizerException.getBaseMessage());
        }
        catch (TextParseException textParseException) {
            throw this.st.exception("Parsing $GENERATE: " + textParseException.getMessage());
        }
    }

    public Record _nextRecord() throws IOException {
        Record record;
        block18: {
            String string;
            Tokenizer.Token token;
            block19: {
                block20: {
                    if (this.included != null) {
                        record = this.included.nextRecord();
                        if (record != null) {
                            return record;
                        }
                        this.included = null;
                    }
                    if (this.generator != null) {
                        record = this.nextGenerated();
                        if (record != null) {
                            return record;
                        }
                        this.endGenerate();
                    }
                    while (true) {
                        Object object;
                        token = this.st.get(true, false);
                        if (token.type == 2) {
                            object = this.st.get();
                            if (object.type == 1) continue;
                            if (object.type == 0) {
                                return null;
                            }
                            this.st.unget();
                            if (this.last == null) {
                                throw this.st.exception("no owner");
                            }
                            record = this.last.getName();
                            break block18;
                        }
                        if (token.type == 1) continue;
                        if (token.type == 0) {
                            return null;
                        }
                        if (token.value.charAt(0) != '$') break block19;
                        string = token.value;
                        if (string.equalsIgnoreCase("$ORIGIN")) {
                            this.origin = this.st.getName(Name.root);
                            this.st.getEOL();
                            continue;
                        }
                        if (string.equalsIgnoreCase("$TTL")) {
                            this.defaultTTL = this.st.getTTL();
                            this.st.getEOL();
                            continue;
                        }
                        if (string.equalsIgnoreCase("$INCLUDE")) {
                            File file;
                            String string2;
                            object = this.st.getString();
                            if (this.file != null) {
                                string2 = this.file.getParent();
                                file = new File(string2, (String)object);
                            } else {
                                file = new File((String)object);
                            }
                            string2 = this.origin;
                            token = this.st.get();
                            if (token.isString()) {
                                string2 = this.parseName(token.value, Name.root);
                                this.st.getEOL();
                            }
                            this.included = new Master(file, (Name)string2, this.defaultTTL);
                            return this.nextRecord();
                        }
                        if (!string.equalsIgnoreCase("$GENERATE")) break block20;
                        if (this.generator != null) {
                            throw new IllegalStateException("cannot nest $GENERATE");
                        }
                        this.startGenerate();
                        if (!this.noExpandGenerate) break;
                        this.endGenerate();
                    }
                    return this.nextGenerated();
                }
                throw this.st.exception("Invalid directive: " + string);
            }
            string = token.value;
            record = this.parseName(string, this.origin);
            if (this.last != null && record.equals((Object)this.last.getName())) {
                record = this.last.getName();
            }
        }
        this.parseTTLClassAndType();
        this.last = Record.fromString((Name)record, (int)this.currentType, (int)this.currentDClass, (long)this.currentTTL, (Tokenizer)this.st, (Name)this.origin);
        if (this.needSOATTL) {
            long l = ((SOARecord)this.last).getMinimum();
            this.last.setTTL(l);
            this.defaultTTL = l;
            this.needSOATTL = false;
        }
        return this.last;
    }

    public Record nextRecord() throws IOException {
        Record record = null;
        try {
            record = this._nextRecord();
        }
        finally {
            if (record == null) {
                this.st.close();
            }
        }
        return record;
    }

    public void expandGenerate(boolean bl) {
        this.noExpandGenerate = !bl;
    }

    public Iterator generators() {
        if (this.generators != null) {
            return Collections.unmodifiableList(this.generators).iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    protected void finalize() {
        if (this.st != null) {
            this.st.close();
        }
    }
}

