/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.Random;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Flags;
import org.xbill.DNS.Opcode;
import org.xbill.DNS.Rcode;
import org.xbill.DNS.Section;

/*
 * Exception performing whole class analysis ignored.
 */
public class Header
implements Cloneable {
    private int id;
    private int flags;
    private int[] counts;
    private static Random random = new Random();
    public static final int LENGTH = 12;

    private void init() {
        this.counts = new int[4];
        this.flags = 0;
        this.id = -1;
    }

    public Header(int n) {
        this.init();
        this.setID(n);
    }

    public Header() {
        this.init();
    }

    Header(DNSInput dNSInput) throws IOException {
        this(dNSInput.readU16());
        this.flags = dNSInput.readU16();
        for (int i = 0; i < this.counts.length; ++i) {
            this.counts[i] = dNSInput.readU16();
        }
    }

    public Header(byte[] byArray) throws IOException {
        this(new DNSInput(byArray));
    }

    void toWire(DNSOutput dNSOutput) {
        dNSOutput.writeU16(this.getID());
        dNSOutput.writeU16(this.flags);
        for (int i = 0; i < this.counts.length; ++i) {
            dNSOutput.writeU16(this.counts[i]);
        }
    }

    public byte[] toWire() {
        DNSOutput dNSOutput = new DNSOutput();
        this.toWire(dNSOutput);
        return dNSOutput.toByteArray();
    }

    private static boolean validFlag(int n) {
        return n >= 0 && n <= 15 && Flags.isFlag((int)n);
    }

    private static void checkFlag(int n) {
        if (!Header.validFlag((int)n)) {
            throw new IllegalArgumentException("invalid flag bit " + n);
        }
    }

    static int setFlag(int n, int n2, boolean bl) {
        Header.checkFlag((int)n2);
        if (bl) {
            return n |= 1 << 15 - n2;
        }
        return n &= ~(1 << 15 - n2);
    }

    public void setFlag(int n) {
        Header.checkFlag((int)n);
        this.flags = Header.setFlag((int)this.flags, (int)n, (boolean)true);
    }

    public void unsetFlag(int n) {
        Header.checkFlag((int)n);
        this.flags = Header.setFlag((int)this.flags, (int)n, (boolean)false);
    }

    public boolean getFlag(int n) {
        Header.checkFlag((int)n);
        return (this.flags & 1 << 15 - n) != 0;
    }

    boolean[] getFlags() {
        boolean[] blArray = new boolean[16];
        for (int i = 0; i < blArray.length; ++i) {
            if (!Header.validFlag((int)i)) continue;
            blArray[i] = this.getFlag(i);
        }
        return blArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getID() {
        if (this.id >= 0) {
            return this.id;
        }
        Header header = this;
        synchronized (header) {
            if (this.id < 0) {
                this.id = random.nextInt(65535);
            }
            return this.id;
        }
    }

    public void setID(int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("DNS message ID " + n + " is out of range");
        }
        this.id = n;
    }

    public void setRcode(int n) {
        if (n < 0 || n > 15) {
            throw new IllegalArgumentException("DNS Rcode " + n + " is out of range");
        }
        this.flags &= 0xFFFFFFF0;
        this.flags |= n;
    }

    public int getRcode() {
        return this.flags & 0xF;
    }

    public void setOpcode(int n) {
        if (n < 0 || n > 15) {
            throw new IllegalArgumentException("DNS Opcode " + n + "is out of range");
        }
        this.flags &= 0x87FF;
        this.flags |= n << 11;
    }

    public int getOpcode() {
        return this.flags >> 11 & 0xF;
    }

    void setCount(int n, int n2) {
        if (n2 < 0 || n2 > 65535) {
            throw new IllegalArgumentException("DNS section count " + n2 + " is out of range");
        }
        this.counts[n] = n2;
    }

    void incCount(int n) {
        if (this.counts[n] == 65535) {
            throw new IllegalStateException("DNS section count cannot be incremented");
        }
        int n2 = n;
        this.counts[n2] = this.counts[n2] + 1;
    }

    void decCount(int n) {
        if (this.counts[n] == 0) {
            throw new IllegalStateException("DNS section count cannot be decremented");
        }
        int n2 = n;
        this.counts[n2] = this.counts[n2] - 1;
    }

    public int getCount(int n) {
        return this.counts[n];
    }

    int getFlagsByte() {
        return this.flags;
    }

    public String printFlags() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 16; ++i) {
            if (!Header.validFlag((int)i) || !this.getFlag(i)) continue;
            stringBuffer.append(Flags.string((int)i));
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    String toStringWithRcode(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(";; ->>HEADER<<- ");
        stringBuffer.append("opcode: " + Opcode.string((int)this.getOpcode()));
        stringBuffer.append(", status: " + Rcode.string((int)n));
        stringBuffer.append(", id: " + this.getID());
        stringBuffer.append("\n");
        stringBuffer.append(";; flags: " + this.printFlags());
        stringBuffer.append("; ");
        for (int i = 0; i < 4; ++i) {
            stringBuffer.append(Section.string((int)i) + ": " + this.getCount(i) + " ");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toStringWithRcode(this.getRcode());
    }

    public Object clone() {
        Header header = new Header();
        header.id = this.id;
        header.flags = this.flags;
        System.arraycopy(this.counts, 0, header.counts, 0, this.counts.length);
        return header;
    }
}

