/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.Arrays;
import org.xbill.DNS.ClientSubnetOption;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.EDNSOption;
import org.xbill.DNS.GenericEDNSOption;
import org.xbill.DNS.NSIDOption;
import org.xbill.DNS.Record;
import org.xbill.DNS.WireParseException;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class EDNSOption {
    private final int code;

    public EDNSOption(int n) {
        this.code = Record.checkU16((String)"code", (int)n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        stringBuffer.append(Code.string((int)this.code));
        stringBuffer.append(": ");
        stringBuffer.append(this.optionToString());
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public int getCode() {
        return this.code;
    }

    byte[] getData() {
        DNSOutput dNSOutput = new DNSOutput();
        this.optionToWire(dNSOutput);
        return dNSOutput.toByteArray();
    }

    abstract void optionFromWire(DNSInput var1) throws IOException;

    static EDNSOption fromWire(DNSInput dNSInput) throws IOException {
        int n = dNSInput.readU16();
        int n2 = dNSInput.readU16();
        if (dNSInput.remaining() < n2) {
            throw new WireParseException("truncated option");
        }
        int n3 = dNSInput.saveActive();
        dNSInput.setActive(n2);
        NSIDOption nSIDOption = switch (n) {
            case 3 -> new NSIDOption();
            case 8 -> new ClientSubnetOption();
            default -> new GenericEDNSOption(n);
        };
        nSIDOption.optionFromWire(dNSInput);
        dNSInput.restoreActive(n3);
        return nSIDOption;
    }

    public static EDNSOption fromWire(byte[] byArray) throws IOException {
        return EDNSOption.fromWire((DNSInput)new DNSInput(byArray));
    }

    abstract void optionToWire(DNSOutput var1);

    void toWire(DNSOutput dNSOutput) {
        dNSOutput.writeU16(this.code);
        int n = dNSOutput.current();
        dNSOutput.writeU16(0);
        this.optionToWire(dNSOutput);
        int n2 = dNSOutput.current() - n - 2;
        dNSOutput.writeU16At(n2, n);
    }

    public byte[] toWire() throws IOException {
        DNSOutput dNSOutput = new DNSOutput();
        this.toWire(dNSOutput);
        return dNSOutput.toByteArray();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof EDNSOption)) {
            return false;
        }
        EDNSOption eDNSOption = (EDNSOption)object;
        if (this.code != eDNSOption.code) {
            return false;
        }
        return Arrays.equals(this.getData(), eDNSOption.getData());
    }

    public int hashCode() {
        byte[] byArray = this.getData();
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            n += (n << 3) + (byArray[i] & 0xFF);
        }
        return n;
    }

    abstract String optionToString();
}

