/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.security.PublicKey;
import org.xbill.DNS.DNSSEC;
import org.xbill.DNS.KEYBase;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;

public class DNSKEYRecord
extends KEYBase {
    private static final long serialVersionUID = -8679800040426675002L;

    DNSKEYRecord() {
    }

    Record getObject() {
        return new DNSKEYRecord();
    }

    public DNSKEYRecord(Name name, int n, long l, int n2, int n3, int n4, byte[] byArray) {
        super(name, 48, n, l, n2, n3, n4, byArray);
    }

    public DNSKEYRecord(Name name, int n, long l, int n2, int n3, int n4, PublicKey publicKey) throws DNSSEC.DNSSECException {
        super(name, 48, n, l, n2, n3, n4, DNSSEC.fromPublicKey((PublicKey)publicKey, (int)n4));
        this.publicKey = publicKey;
    }

    void rdataFromString(Tokenizer tokenizer, Name name) throws IOException {
        this.flags = tokenizer.getUInt16();
        this.proto = tokenizer.getUInt8();
        String string = tokenizer.getString();
        this.alg = DNSSEC.Algorithm.value((String)string);
        if (this.alg < 0) {
            throw tokenizer.exception("Invalid algorithm: " + string);
        }
        this.key = tokenizer.getBase64();
    }
}

