/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.nio.ByteBuffer;
import org.xbill.DNS.WireParseException;

public class DNSInput {
    private ByteBuffer byteBuffer;
    private int saved_pos;
    private int saved_end;

    public DNSInput(byte[] byArray) {
        this.byteBuffer = ByteBuffer.wrap(byArray);
        this.saved_pos = -1;
        this.saved_end = -1;
    }

    public DNSInput(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
        this.saved_pos = -1;
        this.saved_end = -1;
    }

    public int current() {
        return this.byteBuffer.position();
    }

    public int remaining() {
        return this.byteBuffer.remaining();
    }

    private void require(int n) throws WireParseException {
        if (n > this.remaining()) {
            throw new WireParseException("end of input");
        }
    }

    public void setActive(int n) {
        if (n > this.byteBuffer.capacity() - this.byteBuffer.position()) {
            throw new IllegalArgumentException("cannot set active region past end of input");
        }
        this.byteBuffer.limit(this.byteBuffer.position() + n);
    }

    public void clearActive() {
        this.byteBuffer.limit(this.byteBuffer.capacity());
    }

    public int saveActive() {
        return this.byteBuffer.limit();
    }

    public void restoreActive(int n) {
        if (n > this.byteBuffer.capacity()) {
            throw new IllegalArgumentException("cannot set active region past end of input");
        }
        this.byteBuffer.limit(this.byteBuffer.position());
    }

    public void jump(int n) {
        if (n >= this.byteBuffer.capacity()) {
            throw new IllegalArgumentException("cannot jump past end of input");
        }
        this.byteBuffer.position(n);
        this.byteBuffer.limit(this.byteBuffer.capacity());
    }

    public void save() {
        this.saved_pos = this.byteBuffer.position();
        this.saved_end = this.byteBuffer.limit();
    }

    public void restore() {
        if (this.saved_pos < 0) {
            throw new IllegalStateException("no previous state");
        }
        this.byteBuffer.position(this.saved_pos);
        this.byteBuffer.limit(this.saved_end);
        this.saved_pos = -1;
        this.saved_end = -1;
    }

    public int readU8() throws WireParseException {
        this.require(1);
        return this.byteBuffer.get() & 0xFF;
    }

    public int readU16() throws WireParseException {
        this.require(2);
        return this.byteBuffer.getShort() & 0xFFFF;
    }

    public long readU32() throws WireParseException {
        this.require(4);
        return (long)this.byteBuffer.getInt() & 0xFFFFFFFFL;
    }

    public void readByteArray(byte[] byArray, int n, int n2) throws WireParseException {
        this.require(n2);
        this.byteBuffer.get(byArray, n, n2);
    }

    public byte[] readByteArray(int n) throws WireParseException {
        this.require(n);
        byte[] byArray = new byte[n];
        this.byteBuffer.get(byArray, 0, n);
        return byArray;
    }

    public byte[] readByteArray() {
        int n = this.remaining();
        byte[] byArray = new byte[n];
        this.byteBuffer.get(byArray, 0, n);
        return byArray;
    }

    public byte[] readCountedString() throws WireParseException {
        int n = this.readU8();
        return this.readByteArray(n);
    }
}

