/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;

public class Compression {
    private static final int TABLE_SIZE = 17;
    private static final int MAX_POINTER = 16383;
    private Entry[] table;
    private boolean verbose = Options.check((String)"verbosecompression");

    public Compression() {
        this.table = new Entry[17];
    }

    public void add(int n, Name name) {
        if (n > 16383) {
            return;
        }
        int n2 = (name.hashCode() & Integer.MAX_VALUE) % 17;
        Entry entry = new Entry();
        entry.name = name;
        entry.pos = n;
        entry.next = this.table[n2];
        this.table[n2] = entry;
        if (this.verbose) {
            System.err.println("Adding " + name + " at " + n);
        }
    }

    public int get(Name name) {
        int n = (name.hashCode() & Integer.MAX_VALUE) % 17;
        int n2 = -1;
        Entry entry = this.table[n];
        while (entry != null) {
            if (entry.name.equals((Object)name)) {
                n2 = entry.pos;
            }
            entry = entry.next;
        }
        if (this.verbose) {
            System.err.println("Looking for " + name + ", found " + n2);
        }
        return n2;
    }
}

