/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.CERTRecord;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.DNSSEC;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.utils.base64;

/*
 * Exception performing whole class analysis ignored.
 */
public class CERTRecord
extends Record {
    public static final int PKIX = 1;
    public static final int SPKI = 2;
    public static final int PGP = 3;
    public static final int URI = 253;
    public static final int OID = 254;
    private static final long serialVersionUID = 4763014646517016835L;
    private int certType;
    private int keyTag;
    private int alg;
    private byte[] cert;

    CERTRecord() {
    }

    Record getObject() {
        return new CERTRecord();
    }

    public CERTRecord(Name name, int n, long l, int n2, int n3, int n4, byte[] byArray) {
        super(name, 37, n, l);
        this.certType = CERTRecord.checkU16((String)"certType", (int)n2);
        this.keyTag = CERTRecord.checkU16((String)"keyTag", (int)n3);
        this.alg = CERTRecord.checkU8((String)"alg", (int)n4);
        this.cert = byArray;
    }

    void rrFromWire(DNSInput dNSInput) throws IOException {
        this.certType = dNSInput.readU16();
        this.keyTag = dNSInput.readU16();
        this.alg = dNSInput.readU8();
        this.cert = dNSInput.readByteArray();
    }

    void rdataFromString(Tokenizer tokenizer, Name name) throws IOException {
        String string = tokenizer.getString();
        this.certType = CertificateType.value((String)string);
        if (this.certType < 0) {
            throw tokenizer.exception("Invalid certificate type: " + string);
        }
        this.keyTag = tokenizer.getUInt16();
        String string2 = tokenizer.getString();
        this.alg = DNSSEC.Algorithm.value((String)string2);
        if (this.alg < 0) {
            throw tokenizer.exception("Invalid algorithm: " + string2);
        }
        this.cert = tokenizer.getBase64();
    }

    String rrToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.certType);
        stringBuffer.append(" ");
        stringBuffer.append(this.keyTag);
        stringBuffer.append(" ");
        stringBuffer.append(this.alg);
        if (this.cert != null) {
            if (Options.check((String)"multiline")) {
                stringBuffer.append(" (\n");
                stringBuffer.append(base64.formatString((byte[])this.cert, (int)64, (String)"\t", (boolean)true));
            } else {
                stringBuffer.append(" ");
                stringBuffer.append(base64.toString((byte[])this.cert));
            }
        }
        return stringBuffer.toString();
    }

    public int getCertType() {
        return this.certType;
    }

    public int getKeyTag() {
        return this.keyTag;
    }

    public int getAlgorithm() {
        return this.alg;
    }

    public byte[] getCert() {
        return this.cert;
    }

    void rrToWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        dNSOutput.writeU16(this.certType);
        dNSOutput.writeU16(this.keyTag);
        dNSOutput.writeU8(this.alg);
        dNSOutput.writeByteArray(this.cert);
    }
}

