/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.xbill.DNS.AAAARecord;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Name;
import org.xbill.DNS.PTRRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.ReverseMap;
import org.xbill.DNS.TextParseException;

/*
 * Exception performing whole class analysis ignored.
 */
public final class Address {
    public static final int IPv4 = 1;
    public static final int IPv6 = 2;

    private Address() {
    }

    private static byte[] parseV4(String string) {
        byte[] byArray = new byte[4];
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9') {
                if (n4 == 3) {
                    return null;
                }
                if (n4 > 0 && n3 == 0) {
                    return null;
                }
                ++n4;
                n3 *= 10;
                if ((n3 += c - 48) <= 255) continue;
                return null;
            }
            if (c == '.') {
                if (n2 == 3) {
                    return null;
                }
                if (n4 == 0) {
                    return null;
                }
                byArray[n2++] = (byte)n3;
                n3 = 0;
                n4 = 0;
                continue;
            }
            return null;
        }
        if (n2 != 3) {
            return null;
        }
        if (n4 == 0) {
            return null;
        }
        byArray[n2] = (byte)n3;
        return byArray;
    }

    private static byte[] parseV6(String string) {
        int n;
        int n2 = -1;
        byte[] byArray = new byte[16];
        String[] stringArray = string.split(":", -1);
        int n3 = 0;
        int n4 = stringArray.length - 1;
        if (stringArray[0].length() == 0) {
            if (n4 - n3 > 0 && stringArray[1].length() == 0) {
                ++n3;
            } else {
                return null;
            }
        }
        if (stringArray[n4].length() == 0) {
            if (n4 - n3 > 0 && stringArray[n4 - 1].length() == 0) {
                --n4;
            } else {
                return null;
            }
        }
        if (n4 - n3 + 1 > 8) {
            return null;
        }
        int n5 = 0;
        for (n = n3; n <= n4; ++n) {
            int n6;
            if (stringArray[n].length() == 0) {
                if (n2 >= 0) {
                    return null;
                }
                n2 = n5;
                continue;
            }
            if (stringArray[n].indexOf(46) >= 0) {
                if (n < n4) {
                    return null;
                }
                if (n > 6) {
                    return null;
                }
                byte[] byArray2 = Address.toByteArray((String)stringArray[n], (int)1);
                if (byArray2 == null) {
                    return null;
                }
                for (n6 = 0; n6 < 4; ++n6) {
                    byArray[n5++] = byArray2[n6];
                }
                break;
            }
            try {
                int n7;
                for (n7 = 0; n7 < stringArray[n].length(); ++n7) {
                    n6 = stringArray[n].charAt(n7);
                    if (Character.digit((char)n6, 16) >= 0) continue;
                    return null;
                }
                n7 = Integer.parseInt(stringArray[n], 16);
                if (n7 > 65535 || n7 < 0) {
                    return null;
                }
                byArray[n5++] = (byte)(n7 >>> 8);
                byArray[n5++] = (byte)(n7 & 0xFF);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        if (n5 < 16 && n2 < 0) {
            return null;
        }
        if (n2 >= 0) {
            int n8 = 16 - n5;
            System.arraycopy(byArray, n2, byArray, n2 + n8, n5 - n2);
            for (n = n2; n < n2 + n8; ++n) {
                byArray[n] = 0;
            }
        }
        return byArray;
    }

    public static int[] toArray(String string, int n) {
        byte[] byArray = Address.toByteArray((String)string, (int)n);
        if (byArray == null) {
            return null;
        }
        int[] nArray = new int[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            nArray[i] = byArray[i] & 0xFF;
        }
        return nArray;
    }

    public static int[] toArray(String string) {
        return Address.toArray((String)string, (int)1);
    }

    public static byte[] toByteArray(String string, int n) {
        if (n == 1) {
            return Address.parseV4((String)string);
        }
        if (n == 2) {
            return Address.parseV6((String)string);
        }
        throw new IllegalArgumentException("unknown address family");
    }

    public static boolean isDottedQuad(String string) {
        byte[] byArray = Address.toByteArray((String)string, (int)1);
        return byArray != null;
    }

    public static String toDottedQuad(byte[] byArray) {
        return (byArray[0] & 0xFF) + "." + (byArray[1] & 0xFF) + "." + (byArray[2] & 0xFF) + "." + (byArray[3] & 0xFF);
    }

    public static String toDottedQuad(int[] nArray) {
        return nArray[0] + "." + nArray[1] + "." + nArray[2] + "." + nArray[3];
    }

    private static Record[] lookupHostName(String string, boolean bl) throws UnknownHostException {
        try {
            Lookup lookup = new Lookup(string, 1);
            Record[] recordArray = lookup.run();
            if (recordArray == null) {
                Record[] recordArray2;
                if (lookup.getResult() == 4 && (recordArray2 = new Lookup(string, 28).run()) != null) {
                    return recordArray2;
                }
                throw new UnknownHostException("unknown host");
            }
            if (!bl) {
                return recordArray;
            }
            Record[] recordArray3 = new Lookup(string, 28).run();
            if (recordArray3 == null) {
                return recordArray;
            }
            Record[] recordArray4 = new Record[recordArray.length + recordArray3.length];
            System.arraycopy(recordArray, 0, recordArray4, 0, recordArray.length);
            System.arraycopy(recordArray3, 0, recordArray4, recordArray.length, recordArray3.length);
            return recordArray4;
        }
        catch (TextParseException textParseException) {
            throw new UnknownHostException("invalid name");
        }
    }

    private static InetAddress addrFromRecord(String string, Record record) throws UnknownHostException {
        InetAddress inetAddress = record instanceof ARecord ? ((ARecord)record).getAddress() : ((AAAARecord)record).getAddress();
        return InetAddress.getByAddress(string, inetAddress.getAddress());
    }

    public static InetAddress getByName(String string) throws UnknownHostException {
        try {
            return Address.getByAddress((String)string);
        }
        catch (UnknownHostException unknownHostException) {
            Record[] recordArray = Address.lookupHostName((String)string, (boolean)false);
            return Address.addrFromRecord((String)string, (Record)recordArray[0]);
        }
    }

    public static InetAddress[] getAllByName(String string) throws UnknownHostException {
        try {
            InetAddress inetAddress = Address.getByAddress((String)string);
            return new InetAddress[]{inetAddress};
        }
        catch (UnknownHostException unknownHostException) {
            Record[] recordArray = Address.lookupHostName((String)string, (boolean)true);
            InetAddress[] inetAddressArray = new InetAddress[recordArray.length];
            for (int i = 0; i < recordArray.length; ++i) {
                inetAddressArray[i] = Address.addrFromRecord((String)string, (Record)recordArray[i]);
            }
            return inetAddressArray;
        }
    }

    public static InetAddress getByAddress(String string) throws UnknownHostException {
        byte[] byArray = Address.toByteArray((String)string, (int)1);
        if (byArray != null) {
            return InetAddress.getByAddress(string, byArray);
        }
        byArray = Address.toByteArray((String)string, (int)2);
        if (byArray != null) {
            return InetAddress.getByAddress(string, byArray);
        }
        throw new UnknownHostException("Invalid address: " + string);
    }

    public static InetAddress getByAddress(String string, int n) throws UnknownHostException {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("unknown address family");
        }
        byte[] byArray = Address.toByteArray((String)string, (int)n);
        if (byArray != null) {
            return InetAddress.getByAddress(string, byArray);
        }
        throw new UnknownHostException("Invalid address: " + string);
    }

    public static String getHostName(InetAddress inetAddress) throws UnknownHostException {
        Name name = ReverseMap.fromAddress((InetAddress)inetAddress);
        Record[] recordArray = new Lookup(name, 12).run();
        if (recordArray == null) {
            throw new UnknownHostException("unknown address");
        }
        PTRRecord pTRRecord = (PTRRecord)recordArray[0];
        return pTRRecord.getTarget().toString();
    }

    public static int familyOf(InetAddress inetAddress) {
        if (inetAddress instanceof Inet4Address) {
            return 1;
        }
        if (inetAddress instanceof Inet6Address) {
            return 2;
        }
        throw new IllegalArgumentException("unknown address family");
    }

    public static int addressLength(int n) {
        if (n == 1) {
            return 4;
        }
        if (n == 2) {
            return 16;
        }
        throw new IllegalArgumentException("unknown address family");
    }

    public static InetAddress truncate(InetAddress inetAddress, int n) {
        int n2;
        int n3 = Address.familyOf((InetAddress)inetAddress);
        int n4 = Address.addressLength((int)n3) * 8;
        if (n < 0 || n > n4) {
            throw new IllegalArgumentException("invalid mask length");
        }
        if (n == n4) {
            return inetAddress;
        }
        byte[] byArray = inetAddress.getAddress();
        for (n2 = n / 8 + 1; n2 < byArray.length; ++n2) {
            byArray[n2] = 0;
        }
        n2 = n % 8;
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            n5 |= 1 << 7 - i;
        }
        int n6 = n / 8;
        byArray[n6] = (byte)(byArray[n6] & n5);
        try {
            return InetAddress.getByAddress(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            throw new IllegalArgumentException("invalid address");
        }
    }
}

