/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop.server.rmi;

import java.io.IOException;
import java.net.InetAddress;
import java.rmi.Remote;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JOptionPane;
import jrdesktop.Config;
import jrdesktop.robot;
import jrdesktop.server.rmi.ServerImpl;
import jrdesktop.utilities.ZipUtility;

/*
 * Exception performing whole class analysis ignored.
 */
public class Server
extends Thread {
    private static boolean idle = true;
    private static boolean running = false;
    private static Registry registry;
    private static ServerImpl serverImpl;
    private static robot rt;
    private static ArrayList<Object> Objects;
    public static Hashtable<Integer, InetAddress> viewers;

    public static void Start() {
        idle = false;
        running = false;
        Config.loadConfiguration();
        if (Config.default_address) {
            System.setProperty("java.rmi.server.hostname", Config.server_address);
        } else {
            System.getProperties().remove("java.rmi.server.hostname");
        }
        try {
            serverImpl = new ServerImpl();
            registry = LocateRegistry.createRegistry(Config.server_port);
            registry.rebind("ServerImpl", (Remote)serverImpl);
        }
        catch (Exception exception) {
            exception.getStackTrace();
            Server.Stop();
            JOptionPane.showMessageDialog(null, exception.getMessage(), "Error !!", 0);
            return;
        }
        System.out.println(Server.getStatus());
        running = true;
    }

    public static void Stop() {
        if (running) {
            running = false;
            Server.disconnectAllViewers();
        } else {
            try {
                if (registry != null) {
                    UnicastRemoteObject.unexportObject(registry, true);
                }
            }
            catch (Exception exception) {
                exception.getStackTrace();
            }
        }
        registry = null;
        serverImpl = null;
    }

    public static boolean isRunning() {
        return running;
    }

    public static boolean isIdle() {
        return idle;
    }

    public static void updateData(byte[] byArray, int n) {
        try {
            Object object = ZipUtility.byteArraytoObject((byte[])byArray);
            rt.updateData(object);
        }
        catch (Exception exception) {
            exception.getStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] updateData(int n) {
        byte[] byArray = null;
        Objects.add(rt.CaptureScreenByteArray());
        Objects.add(rt.getScreenRect());
        ArrayList arrayList = Objects;
        synchronized (arrayList) {
            try {
                byArray = ZipUtility.objecttoByteArray((Object)Objects);
            }
            catch (IOException iOException) {
                iOException.getStackTrace();
            }
            Objects = new ArrayList();
        }
        return byArray;
    }

    public static void AddObject(Object object) {
        Objects.add(object);
    }

    public static synchronized int addViewer(InetAddress inetAddress) {
        int n = viewers.size();
        viewers.put(n, inetAddress);
        return n;
    }

    public static synchronized int removeViewer(int n) {
        String string = ((InetAddress)viewers.get(n)).toString();
        viewers.remove(n);
        return n;
    }

    public static void disconnectAllViewers() {
        Enumeration enumeration = viewers.keys();
        while (enumeration.hasMoreElements()) {
            Server.removeViewer((int)((Integer)enumeration.nextElement()));
        }
    }

    public static ArrayList<InetAddress> getViewersAds() {
        ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>();
        for (int i = 0; i < viewers.size(); ++i) {
            arrayList.add((InetAddress)viewers.get(i));
        }
        return arrayList;
    }

    public static int getViewersCount() {
        return viewers.size();
    }

    public static String getStatus() {
        String string = "Running ...at:\n\t" + Config.server_address + ":" + Config.server_port;
        return string;
    }

    static {
        rt = new robot();
        Objects = new ArrayList();
        viewers = new Hashtable();
    }
}

