/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop.server;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import jrdesktop.server.rmi.Server;

public class ActiveConnectionsGUI
extends JFrame {
    DefaultListModel listModel = new DefaultListModel();
    private JButton jButtonClose;
    private JButton jButtonDisconnect;
    private JButton jButtonDisconnectAll;
    private JButton jButtonRefresh;
    private JList jList1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;

    public ActiveConnectionsGUI() {
        this.initComponents();
        this.jList1.setModel(this.listModel);
        this.updateList();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jButtonClose = new JButton();
        this.jButtonDisconnect = new JButton();
        this.jButtonDisconnectAll = new JButton();
        this.jButtonRefresh = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Active Connections");
        this.setResizable(false);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Active Connections"));
        this.jScrollPane1.setViewportView(this.jList1);
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 167, -2).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 218, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.jButtonDisconnect.setText("Disconnect");
        this.jButtonDisconnect.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.jButtonDisconnectAll.setText("Disconnect all");
        this.jButtonDisconnectAll.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.jButtonRefresh.setText("Refresh");
        this.jButtonRefresh.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        GroupLayout groupLayout2 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButtonDisconnect, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonRefresh, -1, 95, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButtonDisconnectAll, -1, 102, Short.MAX_VALUE).addComponent(this.jButtonClose, GroupLayout.Alignment.LEADING, -1, 102, Short.MAX_VALUE)))).addGap(26, 26, 26)));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonDisconnect).addComponent(this.jButtonDisconnectAll)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonRefresh).addComponent(this.jButtonClose)).addContainerGap()));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((dimension.width - 247) / 2, (dimension.height - 380) / 2, 247, 380);
    }

    private void jButtonCloseActionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    private void jButtonDisconnectActionPerformed(ActionEvent actionEvent) {
        int n = this.jList1.getSelectedIndex();
        if (n == -1) {
            return;
        }
        InetAddress inetAddress = (InetAddress)this.jList1.getSelectedValue();
        if (JOptionPane.showConfirmDialog((Component)this, "Disconnect " + inetAddress.toString() + " ? ", "Confirm Dialog", 2, 3) == 2) {
            return;
        }
        Server.removeViewer((int)n);
        this.listModel.remove(n);
    }

    private void jButtonRefreshActionPerformed(ActionEvent actionEvent) {
        this.listModel.clear();
        this.updateList();
    }

    private void jButtonDisconnectAllActionPerformed(ActionEvent actionEvent) {
        int n = this.jList1.getModel().getSize();
        if (n == 0) {
            return;
        }
        if (JOptionPane.showConfirmDialog((Component)this, "Disconnect all viewers ? ", "Confirm Dialog", 2, 3) == 0) {
            Server.disconnectAllViewers();
        }
        this.listModel.clear();
        this.updateList();
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void updateList() {
        if (Server.getViewersCount() == 0) {
            return;
        }
        Object[] objectArray = (Object[])Server.getViewersAds().toArray().clone();
        for (int i = 0; i < objectArray.length; ++i) {
            this.listModel.addElement(objectArray[i]);
        }
    }
}

