package jrdesktop.viewer;

import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

import jrdesktop.SysTray;
import jrdesktop.main;

/**
 * ViewerGUI.java
 * @author  benbac
 */

public class ViewerGUI extends javax.swing.JFrame {
                 
    private Recorder recorder;
   
    /** Creates new form MainFrame */
    public ViewerGUI(Recorder recorder) {
        this.recorder = recorder;
        initComponents();
        jScrollPane1.setViewportView(recorder.screenPlayer);        
        setVisible(true);
    }  
  
    public void Start() {
        if (recorder.isRecording())
            recorder.Stop();
        else
            recorder.Start();
        
        if (recorder.isRecording()) {                       
            setIconImage(new ImageIcon(main.ALIVE_ICON).getImage());
            setTitle("jrdesktop Viewer [" +Config.server_address + "]");
        } else {
            setTitle("jrdesktop Viewer");
            setIconImage(new ImageIcon(main.WAIT_ICON).getImage());            
        }           
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        setTitle(" jrdesktop Viewer");
        setIconImage(new ImageIcon(main.WAIT_ICON).getImage());
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
        });

        jScrollPane1.setFocusable(false);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 892, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPane1, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 466, Short.MAX_VALUE)
        );

        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setBounds((screenSize.width-900)/2, (screenSize.height-500)/2, 900, 500);
    }// </editor-fold>//GEN-END:initComponents

    private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
        if (evt.getID() == WindowEvent.WINDOW_CLOSING) {
            if (JOptionPane.showConfirmDialog(null, "Exit Viewer ?", "Confirm Dialog", 
                JOptionPane.OK_CANCEL_OPTION) == JOptionPane.OK_OPTION) {
                if (recorder.isRecording())                    
                    recorder.viewer.Stop();
                    if (SysTray.isSupported()) 
                        dispose();
                    else
                        main.exit();
            }            
        }    
        else
            super.processWindowEvent(evt);
    }//GEN-LAST:event_formWindowClosing
         
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane jScrollPane1;
    // End of variables declaration//GEN-END:variables
    
}
