/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.logging;

import com.ebay.sdk.logging.SingleCallMetrics;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class CallMetrics {
    public static final int NUMBER_OF_COLUMNS = 5;
    private HashMap callMetricsTable = new HashMap();
    private static final String SPACES = "                                 ";

    static void printOneNumber(PrintStream printStream, long l) {
        String string = String.valueOf(l);
        printStream.print(string + SPACES.substring(0, 10 - string.length()));
    }

    static void printOneString(PrintStream printStream, String string, int n) {
        printStream.print(string + SPACES.substring(0, n - string.length()));
    }

    public synchronized void addCallMetrics(SingleCallMetrics singleCallMetrics) {
        String string = singleCallMetrics.getCallname();
        Vector<SingleCallMetrics> vector = (Vector<SingleCallMetrics>)this.callMetricsTable.get(string);
        if (null == vector) {
            vector = new Vector<SingleCallMetrics>();
            this.callMetricsTable.put(string, vector);
        }
        vector.add(singleCallMetrics);
    }

    public void generateReport(PrintStream printStream) {
        if (this.callMetricsTable.size() == 0) {
            printStream.println("No metrics data found");
            return;
        }
        for (String string : this.callMetricsTable.keySet()) {
            List list = (List)this.callMetricsTable.get(string);
            printStream.println("== " + string + " ==");
            this.generateReportForSingleCallname(printStream, list);
            printStream.println("\n");
        }
    }

    public void generateReportForSingleCallname(PrintStream printStream, List list) {
        printStream.println("Number of calls recorded: " + list.size());
        Collection collection = this.normalize(list);
        printStream.println("Number of calls for statistics: " + collection.size());
        printStream.print("Total" + SPACES.substring(0, 10 - "Total".length()));
        printStream.print("PreJAXB" + SPACES.substring(0, 10 - "PreJAXB".length()));
        printStream.print("PostJAXB" + SPACES.substring(0, 10 - "PostJAXB".length()));
        printStream.print("Network" + SPACES.substring(0, 10 - "Network".length()));
        printStream.print("Server" + SPACES.substring(0, 10 - "Server".length()));
        printStream.print("Start Time" + SPACES.substring(0, 10 - "Start Time".length()));
        printStream.println();
        printStream.println("=========================================================================");
        for (Object object : list) {
            ((SingleCallMetrics)object).generateReport(printStream);
        }
        printStream.println("=========================================================================");
        if (collection.size() != 0) {
            Object object;
            object = this.generateAverage(collection);
            for (int i = 0; i < ((Object)object).length; ++i) {
                CallMetrics.printOneNumber(printStream, (long)object[i]);
            }
        }
        printStream.println();
    }

    private long[] generateAverage(Collection collection) {
        long[] lArray = new long[5];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = 0L;
        }
        for (SingleCallMetrics singleCallMetrics : collection) {
            singleCallMetrics.updateTotals(lArray);
        }
        int n = 0;
        while (n < lArray.length) {
            int n2 = n++;
            lArray[n2] = lArray[n2] / (long)collection.size();
        }
        return lArray;
    }

    private Collection normalize(List list) {
        Collections.sort(list, new SortByTurnAroundTime());
        int n = list.size();
        int n2 = (int)(5.0 * (double)n / 100.0 + 0.5);
        if (n2 <= 0) {
            n2 = 1;
        }
        ArrayList arrayList = new ArrayList();
        Iterator iterator = list.iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (n3 >= n2 && n3 < n - n2) {
                arrayList.add(e);
            }
            ++n3;
        }
        return arrayList;
    }

    private static class SortByTurnAroundTime
    implements Comparator {
        private SortByTurnAroundTime() {
        }

        public int compare(Object object, Object object2) {
            if (!(object instanceof SingleCallMetrics)) {
                return 0;
            }
            SingleCallMetrics singleCallMetrics = (SingleCallMetrics)object;
            long l = singleCallMetrics.getTurnaroundTime();
            if (!(object2 instanceof SingleCallMetrics)) {
                return 0;
            }
            SingleCallMetrics singleCallMetrics2 = (SingleCallMetrics)object2;
            long l2 = singleCallMetrics2.getTurnaroundTime();
            if (l > l2) {
                return -1;
            }
            if (l < l2) {
                return 1;
            }
            return 0;
        }
    }
}

