/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk;

import com.ebay.sdk.SdkException;
import com.ebay.sdk.util.XmlUtil;
import com.ebay.soap.eBLBaseComponents.ErrorType;
import com.ebay.soap.eBLBaseComponents.SeverityCodeType;
import javax.xml.soap.Detail;
import javax.xml.soap.SOAPFault;
import javax.xml.ws.soap.SOAPFaultException;
import org.w3c.dom.Node;

public class SdkSoapException
extends SdkException {
    private ErrorType errorType;

    public static SdkSoapException fromSOAPFaultException(SOAPFaultException sOAPFaultException) {
        ErrorType errorType = new ErrorType();
        SOAPFault sOAPFault = sOAPFaultException.getFault();
        errorType.setShortMessage(sOAPFault.getFaultString());
        Detail detail = sOAPFault.getDetail();
        if (detail != null) {
            try {
                String string = XmlUtil.getChildString((Node)detail, "//Severity");
                if (string != null && string.length() > 0) {
                    errorType.setSeverityCode(SeverityCodeType.fromValue(string));
                }
                if ((string = XmlUtil.getChildString((Node)detail, "//ErrorCode")) != null && string.length() > 0) {
                    errorType.setErrorCode(string);
                }
                if ((string = XmlUtil.getChildString((Node)detail, "//DetailedMessage")) != null && string.length() > 0) {
                    errorType.setLongMessage(string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new SdkSoapException(errorType, (Exception)sOAPFaultException);
    }

    protected SdkSoapException(ErrorType errorType, Exception exception) {
        super(exception);
        this.errorType = errorType;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public void setErrorType(ErrorType errorType) {
        this.errorType = errorType;
    }

    @Override
    public String getMessage() {
        String string = this.errorType.getLongMessage();
        if (string != null) {
            return string;
        }
        string = this.errorType.getShortMessage();
        if (string != null) {
            return string;
        }
        return this.errorType.getErrorCode().toString();
    }

    public boolean containsErrorCode(String string) {
        return this.errorType.getErrorCode().toString().equals(string);
    }
}

