/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk;

import com.ebay.sdk.ApiContext;
import com.ebay.sdk.RequestContext;
import com.ebay.sdk.SdkException;
import com.ebay.sdk.handler.EBayServiceHandlerResolver;
import com.ebay.soap.eBLBaseComponents.EBayAPIInterface;
import com.ebay.soap.eBLBaseComponents.EBayAPIInterfaceService;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SdkAPIInterfaceServiceLocator {
    private static final String JAXWS_CONNECT_TIMEOUT = "com.sun.xml.ws.connect.timeout";
    private static final ArrayList<EBayAPIInterface> apiPool = new ArrayList();
    private static final String EBAY_WSDL = "eBaySvc.wsdl";
    private static final String EBAY_SERVICE_NAME = "eBayAPIInterfaceService";
    private static final String READ_TIMEOUT = "com.sun.xml.ws.request.timeout";
    private static final Integer lock = new Integer(0);
    private static EBayAPIInterfaceService service;
    private static final Logger log;

    SdkAPIInterfaceServiceLocator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static EBayAPIInterface getEBayAPI(ApiContext apiContext, RequestContext requestContext) {
        EBayAPIInterface eBayAPIInterface = null;
        Integer n = lock;
        synchronized (n) {
            eBayAPIInterface = apiPool.isEmpty() ? service.getEBayAPI() : apiPool.remove(0);
        }
        SdkAPIInterfaceServiceLocator.initRequestContext(eBayAPIInterface, apiContext, requestContext);
        return eBayAPIInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void releaseEBayAPI(EBayAPIInterface eBayAPIInterface) {
        if (eBayAPIInterface != null) {
            Integer n = lock;
            synchronized (n) {
                apiPool.add(eBayAPIInterface);
            }
        }
    }

    private static void initRequestContext(EBayAPIInterface eBayAPIInterface, ApiContext apiContext, RequestContext requestContext) {
        if (eBayAPIInterface == null) {
            return;
        }
        Map map = ((BindingProvider)eBayAPIInterface).getRequestContext();
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        map.put("api_context", apiContext);
        int n = apiContext.getTimeout();
        if (n > 0) {
            map.put(JAXWS_CONNECT_TIMEOUT, n);
            map.put(READ_TIMEOUT, n);
        } else {
            if (map.containsKey(JAXWS_CONNECT_TIMEOUT)) {
                map.remove(JAXWS_CONNECT_TIMEOUT);
            }
            if (map.containsKey(READ_TIMEOUT)) {
                map.remove(READ_TIMEOUT);
            }
        }
        boolean bl = requestContext.isHttpCompressionEnabled();
        if (bl) {
            hashMap.put("Accept-Encoding", Collections.singletonList("gzip"));
            map.put("javax.xml.ws.http.request.headers", hashMap);
        } else if (map.containsKey("javax.xml.ws.http.request.headers")) {
            map.remove("javax.xml.ws.http.request.headers");
        }
        map.put("javax.xml.ws.service.endpoint.address", requestContext.getEndPointAddress());
        boolean bl2 = false;
        if (!requestContext.isoAuthTokenCredentialHTTPHeader()) {
            bl2 = true;
        }
        if (bl2) {
            map.put("soap_requestercredentials_header", bl2 ? Boolean.TRUE : Boolean.FALSE);
            boolean bl3 = requestContext.isFullCredentialsEnabled();
            map.put("full_credentials", bl3 ? Boolean.TRUE : Boolean.FALSE);
            boolean bl4 = requestContext.isApiAccountOnly();
            map.put("api_account_only", bl4 ? Boolean.TRUE : Boolean.FALSE);
        } else {
            if (map.containsKey("soap_requestercredentials_header")) {
                map.remove("soap_requestercredentials_header");
            }
            if (map.containsKey("full_credentials")) {
                map.remove("full_credentials");
            }
            if (map.containsKey("api_account_only")) {
                map.remove("api_account_only");
            }
            String string = apiContext.getApiCredential().getOAuthToken();
            if (requestContext.isoAuthTokenCredentialHTTPHeader() && string != null && string.length() > 0) {
                hashMap.put("X-EBAY-API-IAF-TOKEN", Collections.singletonList(string));
            } else if (map.containsKey("javax.xml.ws.http.request.headers")) {
                map.remove("javax.xml.ws.http.request.headers");
            }
        }
        map.put("javax.xml.ws.http.request.headers", hashMap);
    }

    static {
        log = LoggerFactory.getLogger(SdkAPIInterfaceServiceLocator.class);
        try {
            URL uRL = EBayAPIInterfaceService.class.getClassLoader().getResource(EBAY_WSDL);
            if (uRL == null) {
                throw new SdkException("fail to load ebay wsdl, please ensure that eBaySvc.wsdl is in the classpath!");
            }
            QName qName = new QName("urn:ebay:apis:eBLBaseComponents", EBAY_SERVICE_NAME);
            log.info("loading wsdl : " + uRL.toString());
            service = new EBayAPIInterfaceService(uRL, qName);
            log.info("wsdl loaded and service initialized.");
            EBayServiceHandlerResolver eBayServiceHandlerResolver = new EBayServiceHandlerResolver();
            service.setHandlerResolver(eBayServiceHandlerResolver);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

