/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.call;

import com.ebay.sdk.ApiCall;
import com.ebay.sdk.ApiContext;
import com.ebay.sdk.ApiException;
import com.ebay.sdk.SdkException;
import com.ebay.soap.eBLBaseComponents.AbstractRequestType;
import com.ebay.soap.eBLBaseComponents.DiscountReasonCodeType;
import com.ebay.soap.eBLBaseComponents.ExpressItemRequirementsType;
import com.ebay.soap.eBLBaseComponents.FeesType;
import com.ebay.soap.eBLBaseComponents.ItemType;
import com.ebay.soap.eBLBaseComponents.ListingRecommendationsType;
import com.ebay.soap.eBLBaseComponents.PhotoDisplayCodeType;
import com.ebay.soap.eBLBaseComponents.PictureDetailsType;
import com.ebay.soap.eBLBaseComponents.VerifyAddFixedPriceItemRequestType;
import com.ebay.soap.eBLBaseComponents.VerifyAddFixedPriceItemResponseType;

public class VerifyAddFixedPriceItemCall
extends ApiCall {
    private ItemType item = null;
    private String returnedItemID = null;
    private String returnedSKU = null;
    private FeesType returnedFees = null;
    private Boolean returnedExpressListing = null;
    private ExpressItemRequirementsType returnedExpressItemRequirements = null;
    private String returnedCategoryID = null;
    private String returnedCategory2ID = null;
    private DiscountReasonCodeType[] returnedDiscountReason = null;
    private ListingRecommendationsType returnedListingRecommendations = null;
    private final String IMG_URL_FORMAT = "http://i0.ebayimg.ebay.com/i0/00/";
    private final String JPG_EXT = ".jpg";
    private String[] pictureFiles = null;

    public VerifyAddFixedPriceItemCall() {
    }

    public VerifyAddFixedPriceItemCall(ApiContext apiContext) {
        super(apiContext);
    }

    public FeesType verifyAddFixedPriceItem() throws ApiException, SdkException, Exception {
        VerifyAddFixedPriceItemRequestType req = new VerifyAddFixedPriceItemRequestType();
        if (this.pictureFiles != null) {
            if (this.item.getPictureDetails() == null) {
                PictureDetailsType pictureDetails = new PictureDetailsType();
                pictureDetails.setPhotoDisplay(PhotoDisplayCodeType.NONE);
                this.item.setPictureDetails(pictureDetails);
            }
            String[] uris = new String[this.pictureFiles.length];
            for (int i = 0; i < this.pictureFiles.length; ++i) {
                uris[i] = "http://i0.ebayimg.ebay.com/i0/00/" + new Integer(i).toString() + ".jpg";
            }
            this.item.getPictureDetails().setPictureURL(uris);
        }
        if (this.item != null) {
            req.setItem(this.item);
        }
        VerifyAddFixedPriceItemResponseType resp = (VerifyAddFixedPriceItemResponseType)this.execute((AbstractRequestType)req);
        this.returnedItemID = resp.getItemID();
        this.returnedSKU = resp.getSKU();
        this.returnedFees = resp.getFees();
        this.returnedExpressListing = resp.isExpressListing();
        this.returnedExpressItemRequirements = resp.getExpressItemRequirements();
        this.returnedCategoryID = resp.getCategoryID();
        this.returnedCategory2ID = resp.getCategory2ID();
        this.returnedDiscountReason = resp.getDiscountReason();
        this.returnedListingRecommendations = resp.getListingRecommendations();
        return this.getReturnedFees();
    }

    public ItemType getItem() {
        return this.item;
    }

    public void setItem(ItemType item) {
        this.item = item;
    }

    public String[] getPictureFiles() {
        return this.pictureFiles;
    }

    public void setPictureFiles(String[] pictureFiles) {
        this.pictureFiles = pictureFiles;
    }

    public FeesType verifyAddFixedPriceItem(ItemType item) throws ApiException, SdkException, Exception {
        VerifyAddFixedPriceItemRequestType request = new VerifyAddFixedPriceItemRequestType();
        request.setItem(item);
        if (this.pictureFiles != null) {
            if (item.getPictureDetails() == null) {
                PictureDetailsType pictureDetails = new PictureDetailsType();
                pictureDetails.setPhotoDisplay(PhotoDisplayCodeType.NONE);
                item.setPictureDetails(pictureDetails);
            }
            String[] uris = new String[this.pictureFiles.length];
            for (int i = 0; i < this.pictureFiles.length; ++i) {
                uris[i] = "http://i0.ebayimg.ebay.com/i0/00/" + new Integer(i).toString() + ".jpg";
            }
            item.getPictureDetails().setPictureURL(uris);
        }
        VerifyAddFixedPriceItemResponseType resp = (VerifyAddFixedPriceItemResponseType)this.execute((AbstractRequestType)request);
        return resp.getFees();
    }

    public String getReturnedCategory2ID() {
        return this.returnedCategory2ID;
    }

    public String getReturnedCategoryID() {
        return this.returnedCategoryID;
    }

    public DiscountReasonCodeType[] getReturnedDiscountReason() {
        return this.returnedDiscountReason;
    }

    public ExpressItemRequirementsType getReturnedExpressItemRequirements() {
        return this.returnedExpressItemRequirements;
    }

    public Boolean getReturnedExpressListing() {
        return this.returnedExpressListing;
    }

    public FeesType getReturnedFees() {
        return this.returnedFees;
    }

    public String getReturnedItemID() {
        return this.returnedItemID;
    }

    public ListingRecommendationsType getReturnedListingRecommendations() {
        return this.returnedListingRecommendations;
    }

    public String getReturnedSKU() {
        return this.returnedSKU;
    }
}

