/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.call;

import com.ebay.sdk.ApiCall;
import com.ebay.sdk.ApiContext;
import com.ebay.sdk.ApiException;
import com.ebay.sdk.SdkException;
import com.ebay.soap.eBLBaseComponents.AbstractRequestType;
import com.ebay.soap.eBLBaseComponents.EndItemRequestType;
import com.ebay.soap.eBLBaseComponents.EndItemResponseType;
import com.ebay.soap.eBLBaseComponents.EndReasonCodeType;
import java.util.Calendar;

public class EndItemCall
extends ApiCall {
    private String itemID = null;
    private EndReasonCodeType endingReason = null;
    private String sellerInventoryID = null;
    private Calendar returnedEndTime = null;

    public EndItemCall() {
    }

    public EndItemCall(ApiContext apiContext) {
        super(apiContext);
    }

    public Calendar endItem() throws ApiException, SdkException, Exception {
        EndItemRequestType req = new EndItemRequestType();
        if (this.itemID == null && this.sellerInventoryID == null) {
            throw new SdkException("Please set ItemID or sellerInventoryID (for Half items) to be ended.");
        }
        if (this.itemID != null && this.sellerInventoryID != null) {
            throw new SdkException("Please set either an ItemID or a sellerInventoryID (for Half items) to be ended.");
        }
        if (this.itemID != null) {
            req.setItemID(this.itemID);
        }
        if (this.endingReason != null) {
            req.setEndingReason(this.endingReason);
        }
        if (this.sellerInventoryID != null) {
            req.setSellerInventoryID(this.sellerInventoryID);
        }
        EndItemResponseType resp = (EndItemResponseType)this.execute((AbstractRequestType)req);
        this.returnedEndTime = resp.getEndTime();
        return this.getReturnedEndTime();
    }

    public EndReasonCodeType getEndingReason() {
        return this.endingReason;
    }

    public void setEndingReason(EndReasonCodeType endingReason) {
        this.endingReason = endingReason;
    }

    public String getItemID() {
        return this.itemID;
    }

    public void setItemID(String itemID) {
        this.itemID = itemID;
    }

    public String getSellerInventoryID() {
        return this.sellerInventoryID;
    }

    public void setSellerInventoryID(String sellerInventoryID) {
        this.sellerInventoryID = sellerInventoryID;
    }

    public Calendar getReturnedEndTime() {
        return this.returnedEndTime;
    }
}

