/*
 * Decompiled with CFR 0.152.
 */
package de.jgsoftwares.dnsserver.dao;

import de.jgsoftwares.dnsserver.dao.iDaoDnsEntry;
import de.jgsoftwares.dnsserver.dao.interfaces.CrudMDNS;
import de.jgsoftwares.dnsserver.dao.interfaces.JPAMDNS;
import de.jgsoftwares.dnsserver.model.MDNS;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class DaoDnsEntry
implements iDaoDnsEntry {
    @Autowired
    @Qualifier(value="defaultJdbcTemplate")
    JdbcTemplate jtm;
    @Autowired
    JPAMDNS jpadb;
    @Autowired
    CrudMDNS crudmdns;

    public List<MDNS> getdnsentrys() {
        List ldnsentry = this.jtm.query("select * from dns", (RowMapper)new BeanPropertyRowMapper(MDNS.class));
        return ldnsentry;
    }

    public List<MDNS> getforwarddnsentry() {
        List forwardlistdns = this.jtm.query("SELECT * FROM DNS where forwarddns is not null group by dnszone", (RowMapper)new BeanPropertyRowMapper(MDNS.class));
        return forwardlistdns;
    }

    public List<MDNS> getreversednsentry() {
        List reverselistdns = this.jtm.query("SELECT * FROM DNS where reversedns is not null group by dnszone", (RowMapper)new BeanPropertyRowMapper(MDNS.class));
        return reverselistdns;
    }

    public Long getForwarddnsCount() {
        Long forwardlistdnscount = (Long)this.jtm.queryForObject("select count(dnszone) from dns where forwarddns is not null group by dnszone", Long.class);
        return forwardlistdnscount;
    }

    public Long getReversednsCount() {
        Long forwardlistdnscount = (Long)this.jtm.queryForObject("select count(dnszone) from dns where reversedns is not null group by dnszone", Long.class);
        return forwardlistdnscount;
    }

    public void createnamedconfoptions() {
        try {
            BufferedWriter bw = null;
            File file = new File("/etc/bind/named.conf.options");
            String stcommend = new String(";namedconfoptions\n\n");
            String stoptnamedconf = new String("options {\n        directory \"/etc/bind\";\n        recursion no;\n        listen-on port 53 { localhost; 192.168.178.0/24; };\n        allow-recursion { none; };\n        allow-query { localhost; 192.168.178.0/24; };\n        allow-query-cache { none; };\n        \n        forwarders {\n                8.8.8.8;\n                8.8.4.4;\n        };\n};");
            FileWriter fw = new FileWriter(file);
            bw = new BufferedWriter(fw);
            bw.write(stcommend);
            bw.write(stoptnamedconf);
            bw.close();
        }
        catch (IOException ex) {
            Logger.getLogger(DaoDnsEntry.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void createnamedconflocal() {
        String stindernetip;
        List getdnsentry = null;
        if (getdnsentry == null) {
            getdnsentry = this.getforwarddnsentry();
        }
        stindernetip = (stindernetip = null) == null ? ((MDNS)getdnsentry.get(0)).getForwarddns() : "127.0.0.1";
        Object stdomainmailserver = null;
        stdomainmailserver = stdomainmailserver == null ? "mail." + ((MDNS)getdnsentry.get(0)).getDnszone() : "mail.localhost.de";
        String stdomain = null;
        stdomain = stdomain == null ? ((MDNS)getdnsentry.get(0)).getDnszone() : "localhost";
        File file1 = new File("/etc/bind/named.conf.local");
        try {
            BufferedWriter bw1 = null;
            FileWriter fw1 = new FileWriter(file1);
            bw1 = new BufferedWriter(fw1);
            String stzonename = new String("zone \"" + stdomain + "\" {\n    type master;\n    file \"/etc/bind/" + stdomain + "\";\n    allow-query { none; };\n    allow-tranfer { none; };\n};");
            bw1.write(stzonename);
            String stnewline = new String();
            bw1.write(stnewline + "\n");
            bw1.write(stnewline + "\n");
            String reservefilename = null;
            List resevelist = this.getreversednsentry();
            reservefilename = ((MDNS)resevelist.get(0)).getDnszone();
            File reservefile = new File("/etc/bind/reserve" + reservefilename);
            String streversezonename = new String("zone \"reverse" + reservefilename + "\" {\n    type master;\n    file \"/etc/bind/reverse" + reservefilename + "\";\n    allow-query { none; };\n    allow-tranfer { none; };\n};");
            bw1.write(streversezonename);
            File reservefilebind = new File("/etc/bind/reverse" + reservefilename);
            this.createreversefile();
            bw1.close();
            fw1.close();
        }
        catch (IOException ex) {
            Logger.getLogger(DaoDnsEntry.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            BufferedWriter bw = null;
            File file = new File("/etc/bind/" + stdomain);
            String stnamedconflocal = new String(";namedconflocal\n\n");
            String sttl = new String("$TTL  86400   ; default TTL for this zone (this 1 day)\n");
            String storgin = new String("$ORIGIN " + stdomain + ".\n");
            String stsoa = new String("@        IN      SOA     " + stdomain + ". root." + stdomain + ". (\n                           2019011502\n                               604800\n                                86400\n                              2419200\n                                86400 )\n");
            String stnameserver = new String("@        IN      NS          " + stdomain + ".\n");
            String stmailserver = new String("@        IN      MX          " + (String)stdomainmailserver + ".\n");
            String starecords = new String("@        IN      A           " + stindernetip + "\nwww      IN      A           " + stindernetip + "\n@        IN      CNAME       " + stdomain + "\n");
            String stoptnamedconf = new String("");
            FileWriter fw = new FileWriter(file);
            bw = new BufferedWriter(fw);
            bw.write(stnamedconflocal);
            bw.write(sttl);
            bw.write(storgin);
            bw.write(stsoa);
            bw.write(stnameserver);
            bw.write(stmailserver);
            bw.write(starecords);
            bw.write(stoptnamedconf);
            bw.close();
            fw.close();
        }
        catch (IOException ex) {
            Logger.getLogger(DaoDnsEntry.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void createreversefile() {
        List reverselist = this.getreversednsentry();
        String stfilename = ((MDNS)reverselist.get(0)).getDnszone();
        File reversefile = new File("/etc/bind/reserve" + stfilename);
        try {
            BufferedWriter rbw = null;
            FileWriter rfw = new FileWriter(reversefile);
            rbw = new BufferedWriter(rfw);
            String sttl = new String("$TTL  86400   ; default TTL for this zone (this 1 day)\n");
            String stsoa = new String("@        IN      SOA     " + stfilename + ". root." + stfilename + ". (\n                           2019011502\n                               604800\n                                86400\n                              2419200\n                                86400 )\n");
            String stnameserver = new String("@          IN      NS          " + stfilename + ".\n");
            String stnameserver1 = new String("100        IN      PTR         " + stfilename + ".\n");
            rfw = new FileWriter(reversefile);
            rbw = new BufferedWriter(rfw);
            rbw.write(sttl);
            rbw.write(stsoa);
            rbw.write(stnameserver);
            rbw.write(stnameserver1);
            rbw.close();
            rfw.close();
        }
        catch (Exception e) {
            System.out.print("Fehler " + String.valueOf(e));
        }
    }

    public void saveforward(MDNS mdns) {
        Integer dnscount = this.getdnscount();
        if (dnscount == 0) {
            dnscount = 1;
            mdns.setId(dnscount.intValue());
        } else {
            dnscount = this.getdnscount() + 1;
            mdns.setId(dnscount.intValue());
        }
        this.jtm.update("insert into dns (id, forwarddns, reversedns, dnszone, dnstype) values (?, ?, ?, ?, ?)", new Object[]{mdns.getId(), mdns.getForwarddns(), mdns.getReversedns(), mdns.getDnszone(), mdns.getDnstype()});
    }

    public void savereverse(MDNS mdns) {
        Integer dnscount = this.getdnscount();
        if (dnscount == 0) {
            dnscount = 1;
            mdns.setId(dnscount.intValue());
        } else {
            dnscount = this.getdnscount() + 1;
            mdns.setId(dnscount.intValue());
        }
        this.jtm.update("insert into dns (id, forwarddns, reversedns, dnszone, dnstype) values (?, ?, ?, ?, ?)", new Object[]{mdns.getId(), mdns.getForwarddns(), mdns.getReversedns(), mdns.getDnszone(), mdns.getDnstype()});
    }

    public Integer getdnscount() {
        Integer dnscount = (Integer)this.jtm.queryForObject("SELECT COUNT(*) from dns", Integer.class);
        return dnscount;
    }

    public List findAllEntry() {
        return this.jpadb.findAll();
    }
}

